/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.medicine;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.IMedicine;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class MedicineItem
extends PixelmonItem {
    private final IMedicine[] healMethods;
    private int friendshipDecreaseNormal;
    private int friendshipDecreaseHigh;

    public MedicineItem(IMedicine ... healMethods) {
        super(new Item.Properties().m_41487_(16));
        this.healMethods = healMethods;
    }

    public MedicineItem setFriendshipDecrease(int normal, int high) {
        this.friendshipDecreaseNormal = normal;
        this.friendshipDecreaseHigh = high;
        return this;
    }

    @Override
    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack, int additionalInfo) {
        this.useMedicine(new WrapperLink(target), additionalInfo);
        return super.useFromBag(pixelmonWrapper, target, stack, additionalInfo);
    }

    public boolean useMedicine(PokemonLink target, int additionalInfo) {
        boolean success = false;
        for (IMedicine healMethod : this.healMethods) {
            success = healMethod.useMedicine(target) || success;
        }
        if (success) {
            int friendship = target.getFriendship();
            target.adjustFriendship(friendship >= 200 ? -this.friendshipDecreaseHigh : -this.friendshipDecreaseNormal);
        } else {
            target.sendMessage("pixelmon.general.noeffect", new Object[0]);
        }
        return success;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerIn, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
    }
}

