/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;

public class StatEnhancingItems
extends HeldItem {
    private final BattleStatsType[] raisedStats;
    private final float statMultiplier;
    private final Supplier<Species>[] affected;

    @SafeVarargs
    public StatEnhancingItems(EnumHeldItems type, BattleStatsType[] raisedStats, float statMultiplier, Supplier<Species> ... affected) {
        super(type, new Item.Properties());
        this.raisedStats = raisedStats;
        this.statMultiplier = statMultiplier;
        this.affected = affected;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (this.canAffect(user)) {
            for (BattleStatsType stat : this.raisedStats) {
                int n = stat.getStatIndex();
                stats[n] = (int)((float)stats[n] * this.statMultiplier);
            }
        }
        return stats;
    }

    protected boolean canAffect(PixelmonWrapper pokemon) {
        Species species = pokemon.getSpecies();
        for (Supplier<Species> p : this.affected) {
            if (!species.is(p.get())) continue;
            return true;
        }
        return false;
    }
}

