/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Overcoat;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.IEquippable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SafetyGogglesItem
extends HeldItem
implements IEquippable {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.of("pixelmon", "textures/playeritems/equippables/safety_goggles.png");

    public SafetyGogglesItem() {
        super(EnumHeldItems.safetyGoggles, new Item.Properties().m_41487_(1));
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (Overcoat.isPowderMove(a)) {
            String nickname = pokemon.getNickname();
            pokemon.bc.sendToAll("pixelmon.abilities.activated", nickname, pokemon.getHeldItem().getLocalizedName());
            pokemon.bc.sendToAll("pixelmon.battletext.noeffect", nickname);
            return false;
        }
        return true;
    }

    @Override
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    @Override
    public String getEquippableModelKey() {
        return "safety_goggles";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return TEXTURE;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return (!stack.m_41782_() || !stack.m_41783_().m_128471_("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }
}

