/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.UpdateMovesetPacket;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;

public class RustedShieldItem
extends HeldItem {
    public RustedShieldItem() {
        super(EnumHeldItems.rustedShield, new Item.Properties());
    }

    @Override
    public void onStartOfBattle(PixelmonWrapper pw) {
        if (pw.getSpecies().is(PixelmonSpecies.ZAMAZENTA)) {
            pw.setForm("crowned");
            Moveset moveset = pw.getMoveset();
            for (Attack attack : moveset) {
                if (!attack.isAttack(AttackRegistry.IRON_HEAD)) continue;
                Attack newAttack = new Attack(AttackRegistry.BEHEMOTH_BASH);
                newAttack.pp = (int)Math.ceil((double)attack.pp / 3.0);
                moveset.replaceMove(AttackRegistry.IRON_HEAD, newAttack);
                if (!(pw.getParticipant() instanceof PlayerParticipant)) continue;
                ServerPlayer player = ((PlayerParticipant)pw.getParticipant()).player;
                NetworkHelper.sendPacket(new UpdateMovesetPacket(pw), player);
            }
            pw.type = pw.getSpecies().getForm("crowned").getTypes();
        }
    }

    @Override
    public void onEndOfBattle(PixelmonWrapper pw) {
        if (pw.getSpecies().is(PixelmonSpecies.ZAMAZENTA)) {
            Moveset moveset = pw.getMoveset();
            for (Attack attack : moveset) {
                if (!attack.isAttack(AttackRegistry.BEHEMOTH_BASH)) continue;
                Attack newAttack = new Attack(AttackRegistry.IRON_HEAD);
                newAttack.pp = attack.pp * 3;
                moveset.replaceMove(AttackRegistry.BEHEMOTH_BASH, newAttack);
            }
        }
    }
}

