/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.Item;

public class MetronomeItem
extends HeldItem {
    public MetronomeItem() {
        super(EnumHeldItems.metronome, new Item.Properties());
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        if (!user.bc.simulateMode) {
            if (attack.equals(user.choiceLocked)) {
                user.metronomeBoost = Math.min(user.metronomeBoost + 20, 100);
            } else {
                user.choiceLocked = attack;
                user.metronomeBoost = 0;
            }
        }
    }

    @Override
    public double preProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        if (attacker == target) {
            return damage;
        }
        return damage + damage / 100.0 * (double)attacker.metronomeBoost;
    }

    @Override
    public void onMiss(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack) {
        if (!attacker.bc.simulateMode) {
            this.reset(attacker);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode) {
            this.reset(pw);
        }
    }

    private void reset(PixelmonWrapper pw) {
        pw.metronomeBoost = 0;
        pw.choiceLocked = null;
    }
}

