/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SheerForce;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.Item;

public class LifeOrbItem
extends HeldItem {
    public LifeOrbItem() {
        super(EnumHeldItems.lifeorb, new Item.Properties());
    }

    @Override
    public double preProcessDamagingAttackUser(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        if (damage > 0.0) {
            return damage * 1.3;
        }
        return damage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dealtDamage(PixelmonWrapper attacker, PixelmonWrapper defender, Attack attack, DamageTypeEnum damageType) {
        Ability attackerAbility = attacker.getBattleAbility();
        if (attack == null) return;
        if (damageType != DamageTypeEnum.ATTACK) return;
        if (attacker.isFainted()) return;
        if (attackerAbility instanceof MagicGuard) return;
        if (!defender.isFainted()) {
            if (attacker.inParentalBond) return;
        }
        if (attackerAbility instanceof SheerForce) {
            SheerForce sheerForce = (SheerForce)attackerAbility;
            if (sheerForce.powerModified) return;
        }
        boolean bl = true;
        boolean doesRecoil = bl;
        if (!doesRecoil) return;
        int recoil = attacker.getPercentMaxHealth(10.0f);
        if (attacker.isDynamax()) {
            recoil = attacker.getPercentMaxHealth(10.0f, true);
        }
        attacker.bc.sendToAll("pixelmon.helditem.lifeowner", attacker.getNickname());
        attacker.doBattleDamage(attacker, recoil, DamageTypeEnum.ITEM);
    }
}

