/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SheerForce;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.Item;

public class EjectButtonItem
extends HeldItem {
    public EjectButtonItem() {
        super(EnumHeldItems.ejectButton, new Item.Properties());
    }

    @Override
    public void postProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, float damage, DamageTypeEnum damageType) {
        if (!attacker.bc.simulateMode && damage > 0.0f && target.isAlive()) {
            if (attacker.getBattleAbility() instanceof SheerForce && attack.getMove().hasSecondaryEffect()) {
                return;
            }
            if (target.stopsForcedSwitches(target)) {
                return;
            }
            BattleParticipant targetParticipant = target.getParticipant();
            ParticipantType targetType = targetParticipant.getType();
            if (targetType == ParticipantType.WildPokemon || !targetParticipant.hasMorePokemonReserve()) {
                return;
            }
            this.setUpSwitch(target);
            if (targetType == ParticipantType.Player) {
                NetworkHelper.sendPacket(new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, targetParticipant), true), target.getPlayerOwner());
            } else {
                target.bc.switchPokemon(target.getPokemonUUID(), target.getBattleAI().getNextSwitch(target), true);
            }
        }
    }

    private void setUpSwitch(PixelmonWrapper target) {
        target.bc.sendToAll("pixelmon.helditems.ejectbutton", target.getNickname());
        target.setUpSwitchMove();
        target.consumeItem();
    }
}

