/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.Item;

public class ChoiceItem
extends HeldItem {
    private BattleStatsType effectType;

    public ChoiceItem(BattleStatsType choiceItemType) {
        super(EnumHeldItems.choiceItem, new Item.Properties());
        this.effectType = choiceItemType;
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        if (user == null || user.bc == null || attack == null || attack.getActualMove() == null) {
            return;
        }
        if (!(user.bc.simulateMode || user.isDynamax > 0 || attack.getActualMove().getAttackName().equals("Transform") || attack.isAttack(AttackRegistry.STRUGGLE))) {
            user.choiceLocked = attack;
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode && !pw.choiceSwapped) {
            pw.choiceLocked = null;
        }
        pw.choiceSwapped = false;
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper pw) {
        if (!pw.bc.simulateMode && !pw.choiceSwapped) {
            pw.choiceLocked = null;
        }
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.isDynamax <= 0) {
            int n = this.effectType.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        Moveset moveset = pokemon.getMoveset();
        if (!pokemon.bc.simulateMode && !pokemon.choiceSwapped && pokemon.isFainted()) {
            pokemon.choiceLocked = null;
        }
        for (Attack currentMove : moveset) {
            if (pokemon.choiceLocked == null || currentMove.equals(pokemon.choiceLocked)) continue;
            currentMove.setDisabled(true, pokemon);
        }
    }
}

