/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ParadoxBoostAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Protosynthesis;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.QuarkDrive;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.Item;

public class BoosterEnergyItem
extends HeldItem {
    public BoosterEnergyItem() {
        super(EnumHeldItems.boosterEnergy, new Item.Properties());
    }

    @Override
    public void applyPostSwitchEffect(PixelmonWrapper newPokemon) {
        this.activateSwitchEffect(newPokemon);
    }

    private void activateSwitchEffect(PixelmonWrapper newPokemon) {
        Ability ability = newPokemon.pokemon.getAbility();
        if (ability instanceof ParadoxBoostAbility && !newPokemon.hasStatus(StatusType.ParadoxBoost)) {
            ParadoxBoostAbility boostAbility = (ParadoxBoostAbility)ability;
            boostAbility.activateViaItem(newPokemon);
        }
    }

    @Override
    public void onTerrainSwitch(BattleController bc, PixelmonWrapper user, Terrain terrain) {
        Ability ability = user.pokemon.getAbility();
        if (ability instanceof QuarkDrive && terrain.type != StatusType.ElectricTerrain) {
            QuarkDrive boostAbility = (QuarkDrive)ability;
            boostAbility.activateViaItem(user);
        }
    }

    @Override
    public void onWeatherSwitch(BattleController bc, PixelmonWrapper user, Weather weather) {
        Ability ability = user.pokemon.getAbility();
        if (ability instanceof Protosynthesis && weather.type != StatusType.Sunny) {
            Protosynthesis boostAbility = (Protosynthesis)ability;
            boostAbility.activateViaItem(user);
        }
    }
}

