/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.TMType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BlankTechnicalMachineItem
extends HeldItem {
    private final TMType prefix;
    public static final Map<ITechnicalMove, Integer> maxImprintCount = Maps.newHashMap();

    public BlankTechnicalMachineItem(TMType prefix) {
        super(EnumHeldItems.other, new Item.Properties().setNoRepair());
        this.prefix = prefix;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        CompoundTag compound = stack.m_41698_("tm");
        if (compound.m_128451_("id") != 0 || compound.m_128448_("count") != 0) {
            int tmId = compound.m_128451_("id");
            short count = compound.m_128448_("count");
            ITechnicalMove move = ITechnicalMove.getMoveFor(this.prefix, tmId);
            int maxCount = compound.m_128441_("max_count") ? compound.m_128448_("max_count") : (int)(compound.m_128441_("max_count_default") ? compound.m_128448_("max_count_default") : maxImprintCount.getOrDefault(move, 100).intValue());
            tooltip.add((Component)Component.m_237110_((String)"tm.blankdata.tooltip", (Object[])new Object[]{move.getAttack().getLocalizedName(), count, maxCount}));
        } else {
            super.m_7373_(stack, world, tooltip, advanced);
        }
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        ItemStack stack = user.pokemon.getHeldItem();
        if (stack.m_41720_() != this) {
            return;
        }
        ITechnicalMove move = ITechnicalMove.getMoveFor(this.prefix, attack.getActualMove().getAttackName());
        if (move != null) {
            if (stack.m_41737_("tm8") != null || stack.m_41737_("tr8") != null) {
                CompoundTag tr8;
                CompoundTag tm8 = stack.m_41737_("tm8");
                if (tm8 != null) {
                    stack.m_41749_("tm8");
                    stack.m_41783_().m_128365_("tm", (Tag)tm8);
                }
                if ((tr8 = stack.m_41737_("tr8")) != null) {
                    stack.m_41749_("tr8");
                    stack.m_41783_().m_128365_("tm", (Tag)tr8);
                }
            }
            CompoundTag compound = stack.m_41698_("tm");
            if (move.getId() == 0 && !compound.m_128456_()) {
                compound.m_128376_("count", (short)((byte)(compound.m_128448_("count") + 1)));
            } else if (compound.m_128451_("id") == 0) {
                if (maxImprintCount.getOrDefault(move, 0) == -1) {
                    return;
                }
                compound.m_128405_("id", move.getId());
                compound.m_128376_("count", (short)1);
                return;
            }
            if (compound.m_128451_("id") == move.getId() && move.getId() != 0) {
                compound.m_128376_("count", (short)((byte)(compound.m_128448_("count") + 1)));
            }
            int maxCount = compound.m_128441_("max_count") && compound.m_128448_("max_count") != 0 ? compound.m_128448_("max_count") : maxImprintCount.getOrDefault(move, 100).intValue();
            compound.m_128376_("max_count_default", (short)maxImprintCount.getOrDefault(move, 100).intValue());
            if (maxCount <= compound.m_128448_("count")) {
                user.pokemon.setHeldItem(PixelmonItems.createTMStackFor(move, 1));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("tm")) {
            stack.m_41749_("tm");
        }
    }
}

