/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import net.minecraft.world.item.Item;

public class BerryTypeReducingItem
extends BerryItem {
    public Element typeReduced;

    public BerryTypeReducingItem(Item.Properties properties, BerryType berry, Element typeReduced) {
        super(properties, EnumHeldItems.berryTypeReducing, berry);
        this.typeReduced = typeReduced;
    }

    @Override
    public double preProcessDamagingAttackTarget(PixelmonWrapper attacker, PixelmonWrapper target, Attack attack, double damage) {
        if (BerryTypeReducingItem.canEatBerry(target) && attack.getType() == this.typeReduced && (attack.getTypeEffectiveness(attacker, target) >= 2.0 || this.typeReduced == Element.NORMAL)) {
            boolean ripened = target.getBattleAbility().isAbility((Class<? extends Ability>)Ripen.class);
            damage /= (double)(ripened ? 4 : 2);
            target.bc.sendToAll("pixelmon.helditems.berrytypereducing", target.getNickname(), target.getHeldItem().getLocalizedName());
            if (ripened) {
                target.bc.sendToAll("pixelmon.abilities.ripen", target.getNickname(), target.getHeldItem().getLocalizedName());
            }
            super.eatBerry(target);
            target.consumeItem();
        }
        return damage;
    }

    @Override
    public void eatBerry(PixelmonWrapper user) {
    }
}

