/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.IMedicine;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import com.pixelmonmod.pixelmon.items.medicine.MedicineStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BerryStatusItem
extends BerryItem {
    private final StatusType[] statusHealed;
    private final IMedicine healMethod;

    public BerryStatusItem(Item.Properties properties, BerryType berry, StatusType ... statusHealed) {
        super(properties, EnumHeldItems.berryStatus, berry);
        this.healMethod = new MedicineStatus(statusHealed);
        this.statusHealed = statusHealed;
    }

    @Override
    public boolean interact(PixelmonEntity pokemon, ItemStack itemstack, Player player) {
        if (this.healMethod.useMedicine(new DelegateLink(pokemon.getPokemon()))) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onStatusAdded(PixelmonWrapper user, PixelmonWrapper opponent, StatusBase status) {
        if (user.isFainted()) {
            return;
        }
        this.eatBerry(user);
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.eatBerry(newPokemon);
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (BerryStatusItem.canEatBerry(pokemon) && (this.healStatus(pokemon) || pokemon.forceEatingBerry)) {
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        if (!this.healMethod.useMedicine(new WrapperLink(targetWrapper))) {
            targetWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    public boolean healStatus(PixelmonWrapper pokemon) {
        pokemon.eatingBerry = true;
        boolean healed = this.healMethod.useMedicine(new WrapperLink(pokemon));
        pokemon.eatingBerry = false;
        return healed;
    }

    public boolean canHealStatus(StatusType status) {
        for (StatusType type : this.statusHealed) {
            if (type != status) continue;
            return true;
        }
        return false;
    }
}

