/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.battles.BattleMode;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.OpenBattleModePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.PPRestoreItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import java.util.Iterator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BerryLeppaItem
extends BerryItem {
    private Attack move;

    public BerryLeppaItem(Item.Properties properties) {
        super(properties, EnumHeldItems.leppa, BerryType.LEPPA);
    }

    @Override
    public boolean interact(PixelmonEntity pokemon, ItemStack itemstack, Player player) {
        if (!pokemon.getPokemon().getMoveset().hasFullPP()) {
            NetworkHelper.sendPacket(new OpenBattleModePacket(BattleMode.CHOOSE_ETHER, pokemon.getPartyPosition()), (ServerPlayer)player);
            return true;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        this.activate(pokemon);
    }

    private void activate(PixelmonWrapper pokemon) {
        Moveset moveset = pokemon.getMoveset();
        Iterator iterator = moveset.iterator();
        while (iterator.hasNext()) {
            Attack attack;
            this.move = attack = (Attack)iterator.next();
            if (this.move == null || this.move.pp > 0) continue;
            this.eatBerry(pokemon);
            break;
        }
        this.move = null;
    }

    @Override
    public void eatBerry(PixelmonWrapper pixelmon) {
        if (BerryLeppaItem.canEatBerry(pixelmon)) {
            if (this.move == null && pixelmon.attack != null) {
                this.move = pixelmon.attack;
            }
            if (this.move != null) {
                boolean ripened = pixelmon.getBattleAbility().isAbility((Class<? extends Ability>)Ripen.class);
                PPRestoreItem.restorePP(new WrapperLink(pixelmon), this.move, ripened ? 20 : 10, false);
                pixelmon.bc.sendToAll("pixelmon.helditems.consumeleppa", pixelmon.getNickname(), this.move.getMove().getTranslatedName());
                if (ripened) {
                    pixelmon.bc.sendToAll("pixelmon.abilities.ripen", pixelmon.getNickname(), this.getLocalizedName());
                }
            } else if (!pixelmon.forceEatingBerry) {
                return;
            }
            pixelmon.consumeItem();
            super.eatBerry(pixelmon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.activate(newPokemon);
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack, int selectedMove) {
        return PixelmonItems.ether.useFromBag(userWrapper, targetWrapper, stack, selectedMove);
    }
}

