/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HealFixed;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.medicine.MedicinePotion;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BerryJuiceItem
extends HeldItem {
    private final MedicinePotion healMethod = new MedicinePotion(new HealFixed(20));
    private static final int PERCENT_THRESHOLD = 50;

    public BerryJuiceItem(Item.Properties properties) {
        super(EnumHeldItems.berryJuice, properties);
        this.setDrink();
    }

    @Override
    public boolean interact(PixelmonEntity pokemon, ItemStack itemstack, Player player) {
        return this.healMethod.useMedicine(new DelegateLink(pokemon.getPokemon()));
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper pokemon, float damage, DamageTypeEnum damageType) {
        if (pokemon.isAlive() && pokemon.getHealthPercent() <= 50.0f) {
            this.consumeItem(pokemon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.getHealthPercent() <= 50.0f) {
            this.consumeItem(newPokemon);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.applySwitchInEffect(pw);
    }

    private void consumeItem(PixelmonWrapper pokemon) {
        if (this.healPokemon(pokemon)) {
            pokemon.consumeItem();
        }
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        if (!this.healPokemon(userWrapper)) {
            userWrapper.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
        }
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    public boolean healPokemon(PixelmonWrapper pokemon) {
        if (this.healMethod.useMedicine(new WrapperLink(pokemon))) {
            String nickname = pokemon.getNickname();
            pokemon.bc.sendToAll("pixelmon.helditems.consumerestorehp", nickname, this.getLocalizedName());
            return true;
        }
        return false;
    }
}

