/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BerryItem
extends HeldItem
implements IPlantable {
    private BerryType berry;

    public BerryItem(Item.Properties properties, EnumHeldItems heldItemType, BerryType berry) {
        super(heldItemType, properties);
        this.berry = berry;
    }

    @Override
    public String getTooltipText() {
        Object ret = "";
        String fd = ChatFormatting.GOLD + I18n.m_118938_((String)"berry.flavor.spicy", (Object[])new Object[0]) + ": " + this.berry.spicy + "\n" + ChatFormatting.BLUE + I18n.m_118938_((String)"berry.flavor.sweet", (Object[])new Object[0]) + ": " + this.berry.sweet + "\n" + ChatFormatting.RED + I18n.m_118938_((String)"berry.flavor.sour", (Object[])new Object[0]) + ": " + this.berry.sour + "\n" + ChatFormatting.GREEN + I18n.m_118938_((String)"berry.flavor.bitter", (Object[])new Object[0]) + ": " + this.berry.bitter + "\n" + ChatFormatting.YELLOW + I18n.m_118938_((String)"berry.flavor.dry", (Object[])new Object[0]) + ": " + this.berry.dry + "\n" + ChatFormatting.RESET;
        ret = (String)ret + fd;
        if (I18n.m_118936_((String)(this.m_5524_() + ".tooltip"))) {
            ret = (String)ret + I18n.m_118938_((String)(this.m_5524_() + ".tooltip"), (Object[])new Object[0]);
        }
        return ret;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        Player playerIn = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = playerIn.m_21120_(hand);
        if (worldIn.f_46443_ || this.berry == null) {
            return InteractionResult.SUCCESS;
        }
        if (!PixelmonConfigProxy.getGeneral().isAllowPlanting()) {
            return InteractionResult.FAIL;
        }
        if (!this.berry.isImplemented) {
            return InteractionResult.FAIL;
        }
        BlockState groundBlock = worldIn.m_8055_(pos);
        if (facing != Direction.UP || !groundBlock.m_60713_(Blocks.f_50440_) && !groundBlock.m_60713_(Blocks.f_50493_) && !groundBlock.m_60713_(Blocks.f_50335_) && !groundBlock.m_60713_(Blocks.f_50195_)) {
            return InteractionResult.FAIL;
        }
        if (groundBlock.m_60713_(Blocks.f_152481_)) {
            return InteractionResult.FAIL;
        }
        if (!worldIn.m_46859_(pos.m_7494_())) {
            return InteractionResult.FAIL;
        }
        if (!playerIn.m_36204_(pos = pos.m_7494_(), facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41613_() <= 0) {
            return InteractionResult.FAIL;
        }
        if (worldIn.m_8055_(pos).m_60629_(new BlockPlaceContext(context))) {
            BlockState state = this.berry.getSaplingBlock().m_49966_();
            worldIn.m_7731_(pos, state, 3);
            state.m_60734_().m_6402_(worldIn, pos, state, (LivingEntity)playerIn, stack);
            SoundType soundtype = state.getSoundType((LevelReader)worldIn, pos, (Entity)playerIn);
            worldIn.m_5594_(null, pos, this.getPlaceSound(state, worldIn, pos, playerIn), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (!playerIn.m_7500_()) {
                if (stack.m_41613_() <= 1) {
                    playerIn.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity) {
        return state.getSoundType((LevelReader)world, pos, (Entity)entity).m_56777_();
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.berry.getSaplingBlock().m_49966_();
    }

    public BerryType getBerry() {
        return this.berry;
    }
}

