/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Ripen;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.BerryType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.BerryItem;
import net.minecraft.world.item.Item;

public class BerryEnigmaItem
extends BerryItem {
    public BerryEnigmaItem(Item.Properties properties) {
        super(properties, EnumHeldItems.berryEnigma, BerryType.ENIGMA);
    }

    @Override
    public void tookDamage(PixelmonWrapper attacker, PixelmonWrapper defender, float damage, DamageTypeEnum damageType) {
        Attack attack = attacker.attack;
        if (damage > 0.0f && damageType == DamageTypeEnum.ATTACK && attack.getTypeEffectiveness(attacker, defender) >= 2.0 && BerryEnigmaItem.canEatBerry(defender)) {
            this.eatBerry(defender);
        }
    }

    @Override
    public void eatBerry(PixelmonWrapper pokemon) {
        if (BerryEnigmaItem.canEatBerry(pokemon)) {
            if (!pokemon.hasFullHealth()) {
                boolean ripened = pokemon.getBattleAbility().isAbility((Class<? extends Ability>)Ripen.class);
                pokemon.bc.sendToAll("pixelmon.helditems.consumerestorehp", pokemon.getNickname(), this.getLocalizedName());
                if (ripened) {
                    pokemon.bc.sendToAll("pixelmon.abilities.ripen", pokemon.getNickname(), this.getLocalizedName());
                }
                pokemon.healByPercent(ripened ? 50.0f : 25.0f);
            } else if (!pokemon.forceEatingBerry) {
                return;
            }
            super.eatBerry(pokemon);
            pokemon.consumeItem();
        }
    }
}

