/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.armor.armoreffects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItemTiers;
import com.pixelmonmod.pixelmon.items.armor.GenericArmor;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IArmorEffect;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon")
public class ThunderstoneEffect
implements IArmorEffect {
    private static final UUID thunderStoneBoostUUID = UUID.fromString("de4f0383-fcf9-4ba7-8ffc-0767c1ead7b9");
    private static final AttributeModifier SpeedModifier2x = new AttributeModifier(thunderStoneBoostUUID, Attributes.f_22279_.m_22087_(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);

    @SubscribeEvent
    public static void onArmorChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            HashMultimap map = HashMultimap.create();
            map.put((Object)Attributes.f_22279_, (Object)SpeedModifier2x);
            if (IArmorEffect.isWearingFullSet(player, PixelmonItemTiers.THUNDERSTONE_ARMOR)) {
                player.m_21204_().m_22178_((Multimap)map);
            } else {
                player.m_21204_().m_22161_((Multimap)map);
            }
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, ItemStack stack, GenericArmor armor) {
        if (world.f_46443_) {
            return;
        }
        if (IArmorEffect.isWearingFullSet(player, armor.material) && player.f_19797_ % 20 == 1) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 40, 1, true, true));
        }
    }
}

