/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.armor;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.ArmorEffectEvent;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IArmorEffect;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IItemAttributeModifier;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class GenericArmor
extends ArmorItem {
    public IArmorEffect effect = null;
    public IItemAttributeModifier itemAttributeModifier = null;
    public final ArmorMaterial material;

    public GenericArmor(ArmorMaterial material, ArmorItem.Type armorType) {
        super(material, armorType, new Item.Properties());
        this.material = material;
    }

    public GenericArmor setEffect(IArmorEffect effect) {
        this.effect = effect;
        return this;
    }

    public GenericArmor setItemAttributeModifiers(IItemAttributeModifier modifier) {
        this.itemAttributeModifier = modifier;
        return this;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        ArmorEffectEvent.Attribute event = new ArmorEffectEvent.Attribute(this, null, null, null, this.effect, this.itemAttributeModifier);
        ListMultimap build = MultimapBuilder.hashKeys().linkedListValues().build();
        if (!Pixelmon.EVENT_BUS.post((Event)event) && event.getAttributeModifier() != null && slot == EquipmentSlot.FEET) {
            for (Map.Entry entry : event.getAttributeModifier().getAttributeModifiers(null, this).entries()) {
                build.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
            }
        }
        return build;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        ArmorEffectEvent.Effect event = new ArmorEffectEvent.Effect(this, world, player, stack, this.effect, this.itemAttributeModifier);
        if (!Pixelmon.EVENT_BUS.post((Event)event) && event.getArmorEffect() != null) {
            event.getArmorEffect().onArmorTick(world, player, stack, this);
        }
    }

    public String m_5524_() {
        return super.m_5524_();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "pixelmon:textures/models/armor/" + this.modifyArmorName(stack.m_41720_().toString()) + "_layer_" + (slot == EquipmentSlot.LEGS ? 2 : 1) + ".png";
    }

    private String modifyArmorName(String itemName) {
        return itemName.substring(0, itemName.lastIndexOf("_")).toLowerCase();
    }
}

