/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ZygardeCubeItem
extends PixelmonItem {
    public ZygardeCubeItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237110_((String)"pixelmon.items.zygarde_cube.tooltip.cells", (Object[])new Object[]{ZygardeCubeItem.getCellCount(stack)}));
        tooltip.add((Component)Component.m_237110_((String)"pixelmon.items.zygarde_cube.tooltip.cores", (Object[])new Object[]{ZygardeCubeItem.getCoreCount(stack)}));
        Set<CoreType> cores = ZygardeCubeItem.getCoreTypes(stack);
        if (!cores.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"pixelmon.items.zygarde_cube.tooltip.moves"));
            for (CoreType type : cores) {
                if (type.getMove() == null) continue;
                tooltip.add((Component)Component.m_237113_((String)(" - " + type.getMove().getLocalizedName())));
            }
        }
        super.m_7373_(stack, world, tooltip, advanced);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        Level worldIn = context.m_43725_();
        BlockState state = worldIn.m_8055_(pos);
        if (state.m_60734_() instanceof ZygardeCellBlock) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() != this) {
                return InteractionResult.PASS;
            }
            ZygardeCellTileEntity cell = BlockHelper.getTileEntity(ZygardeCellTileEntity.class, (LevelReader)worldIn, pos);
            if (cell != null) {
                if (cell.isPermanent()) {
                    if (cell.addEncounter(player.m_20148_())) {
                        if (ZygardeCubeItem.registerCell(cell, state, player, stack)) {
                            ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.pickup", new Object[0]);
                        }
                    } else {
                        ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.encountered", Component.m_237115_((String)state.m_60734_().m_7705_()));
                    }
                } else if (worldIn.m_7471_(pos, false) && ZygardeCubeItem.registerCell(cell, state, player, stack)) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.pickup", new Object[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public static int getCellCount(ItemStack stack) {
        CompoundTag compound = stack.m_41698_("cells");
        return compound.m_128448_("Count");
    }

    public static void setCellCount(ItemStack stack, int count) {
        if (count > 200) {
            count = 200;
        }
        if (count < 0) {
            count = 0;
        }
        CompoundTag compound = stack.m_41698_("cells");
        compound.m_128376_("Count", (short)count);
    }

    public static int getCoreCount(ItemStack stack) {
        CompoundTag compound = stack.m_41698_("cells");
        return compound.m_128448_("CoreCount");
    }

    public static void setCoreCount(ItemStack stack, int count) {
        if (count > 5) {
            count = 5;
        }
        if (count < 0) {
            count = 0;
        }
        CompoundTag compound = stack.m_41698_("cells");
        compound.m_128376_("CoreCount", (short)count);
    }

    public static boolean hasCore(ItemStack stack, CoreType type) {
        CompoundTag compound = stack.m_41698_("cells");
        return compound.m_128471_("Core" + type.ordinal());
    }

    public static void addCore(ItemStack stack, CoreType type) {
        ZygardeCubeItem.setCoreCount(stack, ZygardeCubeItem.getCoreCount(stack) + 1);
        CompoundTag compound = stack.m_41698_("cells");
        compound.m_128379_("Core" + type.ordinal(), true);
    }

    public static Set<CoreType> getCoreTypes(ItemStack stack) {
        EnumSet<CoreType> set = EnumSet.allOf(CoreType.class);
        set.removeIf(type -> !ZygardeCubeItem.hasCore(stack, type));
        set.remove((Object)CoreType.RANDOM);
        return set;
    }

    public static boolean registerCell(ZygardeCellTileEntity te, BlockState state, Player player, ItemStack stack) {
        boolean core;
        boolean bl = core = state.m_60734_() == PixelmonBlocks.zygarde_core;
        if (core) {
            if (te.getCoreType() == CoreType.RANDOM) {
                EnumSet<CoreType> cores = EnumSet.allOf(CoreType.class);
                cores.remove((Object)CoreType.RANDOM);
                cores.removeAll(ZygardeCubeItem.getCoreTypes(stack));
                if (cores.isEmpty()) {
                    cores = EnumSet.allOf(CoreType.class);
                    cores.remove((Object)CoreType.RANDOM);
                }
                ZygardeCubeItem.addCore(stack, RandomHelper.getRandomElementFromArray(cores.toArray(new CoreType[0])));
                return true;
            }
            if (ZygardeCubeItem.hasCore(stack, te.getCoreType())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.items.zygarde_cube.encountered", Component.m_237115_((String)state.m_60734_().m_7705_()));
                return false;
            }
            ZygardeCubeItem.addCore(stack, te.getCoreType());
            return true;
        }
        ZygardeCubeItem.setCellCount(stack, ZygardeCubeItem.getCellCount(stack) + 1);
        return true;
    }

    public static enum CoreType {
        RANDOM(() -> null),
        CORE_ENFORCER(() -> AttackRegistry.CORE_ENFORCER.orElse(null)),
        THOUSAND_ARROWS(() -> AttackRegistry.THOUSAND_ARROWS.orElse(null)),
        THOUSAND_WAVES(() -> AttackRegistry.THOUSAND_WAVES.orElse(null)),
        EXTREME_SPEED(() -> AttackRegistry.EXTREME_SPEED.orElse(null)),
        DRAGON_DANCE(() -> AttackRegistry.DRAGON_DANCE.orElse(null));

        private static final CoreType[] VALUES;
        private final Supplier<ImmutableAttack> move;

        private CoreType(Supplier<ImmutableAttack> moveName) {
            this.move = moveName;
        }

        public ImmutableAttack getMove() {
            return this.move.get();
        }

        public static CoreType[] getTypes() {
            return new CoreType[]{CORE_ENFORCER, THOUSAND_ARROWS, THOUSAND_WAVES, EXTREME_SPEED, DRAGON_DANCE};
        }

        public static CoreType fromIndex(int index) {
            if (index < 0 || index >= VALUES.length) {
                return RANDOM;
            }
            return VALUES[index];
        }

        static {
            VALUES = CoreType.values();
        }
    }
}

