/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.BerrySaplingBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WailmerPailItem
extends PixelmonItem {
    public WailmerPailItem() {
        super(new Item.Properties().m_41503_(32));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        Direction side = context.m_43719_();
        Level world = context.m_43725_();
        if (!player.m_36204_(pos, side, player.m_21120_(hand))) {
            return InteractionResult.FAIL;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BerrySaplingBlock) {
            BonemealableBlock tree = (BonemealableBlock)state.m_60734_();
            if (tree.m_7370_((LevelReader)world, pos, state)) {
                tree.m_214148_((ServerLevel)world, RandomSource.m_216327_(), pos, state);
                WailmerPailItem.spawnBonemealParticles(world, pos, 15);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.bonemealwatered", new Object[0]);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void spawnBonemealParticles(Level worldIn, BlockPos pos, int amount) {
        block5: {
            BlockState iblockstate;
            if (worldIn.f_46443_) break block5;
            ServerLevel world = (ServerLevel)worldIn;
            if (amount == 0) {
                amount = 15;
            }
            if (!(iblockstate = worldIn.m_8055_(pos)).m_60795_()) {
                for (int i = 0; i < amount; ++i) {
                    double d0 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    double d1 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    double d2 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)((float)pos.m_123341_() + RandomHelper.getRandom().nextFloat()), (double)pos.m_123342_() + (double)RandomHelper.getRandom().nextFloat() * iblockstate.m_60808_((BlockGetter)worldIn, pos).m_83297_(Direction.Axis.Y), (double)((float)pos.m_123343_() + RandomHelper.getRandom().nextFloat()), 1, d0, d1, d2, 0.0);
                }
            } else {
                for (int i1 = 0; i1 < amount; ++i1) {
                    double d0 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    double d1 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    double d2 = RandomHelper.getRandom().nextGaussian() * 0.02;
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)((float)pos.m_123341_() + RandomHelper.getRandom().nextFloat()), (double)pos.m_123342_() + (double)RandomHelper.getRandom().nextFloat() * 1.0, (double)((float)pos.m_123343_() + RandomHelper.getRandom().nextFloat()), 1, d0, d1, d2, 0.0);
                }
            }
        }
    }
}

