/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UIElementItem
extends PixelmonItem {
    public static final String IMAGE = "UIImage";
    public static final String HOVER = "UIHoverImage";
    public static final String TEXT = "UIText";
    public static final String HOVER_TEXT = "UIHoverText";
    public static final String TEXT_JUSTIFICATION = "UITextJustification";
    public static final String TEXT_SCALE = "UITextScale";
    public static final String X_OFFSET = "UIXOffset";
    public static final String Y_OFFSET = "UIYOffset";
    public static final String X_OVERRIDE = "UIXOverride";
    public static final String Y_OVERRIDE = "UIYOverride";
    public static final String Z_LEVEL = "UIZLevel";
    public static final String IMAGE_WIDTH = "UIImageWidth";
    public static final String IMAGE_HEIGHT = "UIImageHeight";
    public static final String IMAGE_U = "UIImageU";
    public static final String IMAGE_V = "UIImageV";
    public static final String SCALE_X = "UIImageScaleX";
    public static final String SCALE_Y = "UIImageScaleY";
    public static final String ROTATION = "UIRotation";
    public static final String R = "UIImageR";
    public static final String G = "UIImageG";
    public static final String B = "UIImageB";
    public static final String A = "UIImageA";
    public static final String HR = "UIImageHR";
    public static final String HG = "UIImageHG";
    public static final String HB = "UIImageHB";
    public static final String HA = "UIImageHA";

    public UIElementItem() {
        super(new Item.Properties());
    }

    public static Builder builder() {
        return new Builder(new ItemStack((ItemLike)PixelmonItems.ui_element));
    }

    public static Builder builder(ItemStack stack) {
        return new Builder(stack);
    }

    public static Optional<ResourceLocation> getImage(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverImage(stack) : UIElementItem.getImage(stack);
    }

    public static Optional<ResourceLocation> getImage(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(IMAGE)) {
            return Optional.empty();
        }
        ResourceLocation rl = ResourceLocationHelper.of(tag.m_128461_(IMAGE));
        return Optional.of(rl);
    }

    public static Optional<ResourceLocation> getHoverImage(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(HOVER)) {
            return UIElementItem.getImage(stack);
        }
        ResourceLocation rl = ResourceLocationHelper.of(tag.m_128461_(HOVER));
        return Optional.of(rl);
    }

    public static Optional<Integer> getXOffset(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(X_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(X_OFFSET));
    }

    public static Optional<Integer> getYOffset(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(Y_OFFSET)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(Y_OFFSET));
    }

    public static Optional<Integer> getXOverride(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(X_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(X_OVERRIDE));
    }

    public static Optional<Integer> getYOverride(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(Y_OVERRIDE)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(Y_OVERRIDE));
    }

    public static Optional<Integer> getZLevel(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(Z_LEVEL)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(Z_LEVEL));
    }

    public static Optional<Integer> getImageWidth(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(IMAGE_WIDTH)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(IMAGE_WIDTH));
    }

    public static Optional<Integer> getImageHeight(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(IMAGE_HEIGHT)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128451_(IMAGE_HEIGHT));
    }

    public static Optional<Float> getImageU(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(IMAGE_U)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.m_128457_(IMAGE_U)));
    }

    public static Optional<Float> getImageV(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(IMAGE_V)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(tag.m_128457_(IMAGE_V)));
    }

    public static Optional<float[]> getColor(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverColor(stack) : UIElementItem.getColor(stack);
    }

    public static Optional<float[]> getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(R)) {
            return Optional.empty();
        }
        return Optional.of(new float[]{tag.m_128457_(R), tag.m_128457_(G), tag.m_128457_(B), tag.m_128457_(A)});
    }

    public static Optional<float[]> getHoverColor(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(HR)) {
            return UIElementItem.getColor(stack);
        }
        return Optional.of(new float[]{tag.m_128457_(HR), tag.m_128457_(HG), tag.m_128457_(HB), tag.m_128457_(HA)});
    }

    public static Optional<String> getText(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TEXT)) {
            return Optional.empty();
        }
        return Optional.of(tag.m_128461_(TEXT));
    }

    public static Optional<String> getHoverText(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(HOVER_TEXT)) {
            return UIElementItem.getText(stack);
        }
        return Optional.of(tag.m_128461_(HOVER_TEXT));
    }

    public static Optional<String> getText(ItemStack stack, boolean hover) {
        return hover ? UIElementItem.getHoverText(stack) : UIElementItem.getText(stack);
    }

    public static TextJustification getTextJustification(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TEXT_JUSTIFICATION)) {
            return TextJustification.RIGHT;
        }
        return TextJustification.get(tag.m_128448_(TEXT_JUSTIFICATION));
    }

    public static short getTextScale(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TEXT_SCALE)) {
            return 12;
        }
        return tag.m_128448_(TEXT_SCALE);
    }

    public static float[] getScale(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return new float[]{1.0f, 1.0f};
        }
        return new float[]{tag.m_128441_(SCALE_X) ? tag.m_128457_(SCALE_X) : 1.0f, tag.m_128441_(SCALE_Y) ? tag.m_128457_(SCALE_Y) : 1.0f};
    }

    public static float getRotation(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(ROTATION)) {
            return 0.0f;
        }
        return tag.m_128457_(ROTATION);
    }

    public static class Builder {
        private final ItemStack stack;

        private Builder(ItemStack stack) {
            this.stack = stack;
            if (!this.stack.m_41782_()) {
                this.stack.m_41751_(new CompoundTag());
            }
        }

        public Builder setImage(String image) {
            this.stack.m_41783_().m_128359_(UIElementItem.IMAGE, image);
            return this;
        }

        public Builder setHoverImage(String image) {
            this.stack.m_41783_().m_128359_(UIElementItem.HOVER, image);
            return this;
        }

        public Builder setText(String text) {
            this.stack.m_41783_().m_128359_(UIElementItem.TEXT, text);
            return this;
        }

        public Builder setHoverText(String text) {
            this.stack.m_41783_().m_128359_(UIElementItem.HOVER_TEXT, text);
            return this;
        }

        public Builder setTextJustification(TextJustification justification) {
            this.stack.m_41783_().m_128376_(UIElementItem.TEXT_JUSTIFICATION, (short)(justification.ordinal() - 1));
            return this;
        }

        public Builder setTextScale(float scale) {
            this.stack.m_41783_().m_128350_(UIElementItem.TEXT_SCALE, scale);
            return this;
        }

        public Builder setPosOffset(int x, int y) {
            this.stack.m_41783_().m_128405_(UIElementItem.X_OFFSET, x);
            this.stack.m_41783_().m_128405_(UIElementItem.Y_OFFSET, y);
            return this;
        }

        public Builder setPosOverride(int x, int y) {
            this.stack.m_41783_().m_128405_(UIElementItem.X_OVERRIDE, x);
            this.stack.m_41783_().m_128405_(UIElementItem.Y_OVERRIDE, y);
            return this;
        }

        public Builder setZLevel(int zLevel) {
            this.stack.m_41783_().m_128405_(UIElementItem.Z_LEVEL, zLevel);
            return this;
        }

        public Builder setSize(int w, int h) {
            this.stack.m_41783_().m_128405_(UIElementItem.IMAGE_WIDTH, w);
            this.stack.m_41783_().m_128405_(UIElementItem.IMAGE_HEIGHT, h);
            return this;
        }

        public Builder setScale(float scale) {
            this.setScale(scale, scale);
            return this;
        }

        public Builder setScale(float x, float y) {
            this.stack.m_41783_().m_128350_(UIElementItem.SCALE_X, x);
            this.stack.m_41783_().m_128350_(UIElementItem.SCALE_Y, y);
            return this;
        }

        public Builder setRotation(float angle) {
            this.stack.m_41783_().m_128350_(UIElementItem.ROTATION, angle);
            return this;
        }

        public Builder setUV(float u, float v) {
            this.stack.m_41783_().m_128350_(UIElementItem.IMAGE_U, u);
            this.stack.m_41783_().m_128350_(UIElementItem.IMAGE_V, v);
            return this;
        }

        public Builder setColor(int r, int g, int b, int a) {
            return this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setColor(float r, float g, float b, float a) {
            this.stack.m_41783_().m_128350_(UIElementItem.R, r);
            this.stack.m_41783_().m_128350_(UIElementItem.G, g);
            this.stack.m_41783_().m_128350_(UIElementItem.B, b);
            this.stack.m_41783_().m_128350_(UIElementItem.A, a);
            return this;
        }

        public Builder setHoverColor(int r, int g, int b, int a) {
            return this.setHoverColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public Builder setHoverColor(float r, float g, float b, float a) {
            this.stack.m_41783_().m_128350_(UIElementItem.HR, r);
            this.stack.m_41783_().m_128350_(UIElementItem.HG, g);
            this.stack.m_41783_().m_128350_(UIElementItem.HB, b);
            this.stack.m_41783_().m_128350_(UIElementItem.HA, a);
            return this;
        }

        public ItemStack build() {
            return this.stack;
        }
    }
}

