/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TumblestoneItem
extends PixelmonItem {
    private Color color;
    private boolean raw;

    public TumblestoneItem(Color color, Item.Properties properties) {
        this(color, false, properties);
    }

    public TumblestoneItem(Color color, boolean raw, Item.Properties properties) {
        super(properties);
        this.color = color;
        this.raw = raw;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        Player playerIn = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = playerIn.m_21120_(hand);
        if (worldIn.f_46443_ || this.color == null) {
            return InteractionResult.SUCCESS;
        }
        if (!PixelmonConfigProxy.getGeneral().isAllowPlanting()) {
            return InteractionResult.FAIL;
        }
        if (!playerIn.m_7500_() || this.raw) {
            return InteractionResult.SUCCESS;
        }
        if (!playerIn.m_36204_(pos = pos.m_7494_(), facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41613_() <= 0) {
            return InteractionResult.FAIL;
        }
        if (worldIn.m_8055_(pos).m_60629_(new BlockPlaceContext(context))) {
            BlockState state = this.fromColour().m_49966_();
            worldIn.m_7731_(pos, state, 3);
            state = worldIn.m_8055_(pos);
            state.m_60734_().m_6402_(worldIn, pos, state, (LivingEntity)playerIn, stack);
            if (!playerIn.m_7500_()) {
                if (stack.m_41613_() <= 1) {
                    playerIn.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Block fromColour() {
        if (this.color == Color.BLACK) {
            return PixelmonBlocks.black_tumblestone;
        }
        if (this.color == Color.RED) {
            return PixelmonBlocks.red_tumblestone;
        }
        return PixelmonBlocks.blue_tumblestone;
    }

    public boolean isRaw() {
        return this.raw;
    }
}

