/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.TeleportItemEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class TeleporterItem
extends PixelmonItem {
    private final String world;
    private final boolean foil;
    private boolean teleportToSpawnpoint = false;

    public TeleporterItem(String world) {
        super(new Item.Properties().m_41487_(1));
        this.world = world;
        this.foil = true;
    }

    public TeleporterItem(Item.Properties properties, String world, boolean teleportToSpawnpoint) {
        super(properties);
        this.world = world;
        this.teleportToSpawnpoint = teleportToSpawnpoint;
        this.foil = !teleportToSpawnpoint;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            return this.doTeleport(playerIn, stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected InteractionResultHolder<ItemStack> doTeleport(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            TeleportItemEvent.Pre preEvent;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos teleportPosition = new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_());
            if (this.teleportToSpawnpoint) {
                teleportPosition = player.m_21257_().orElse(serverPlayer.m_9236_().m_220360_());
            }
            if (!Pixelmon.EVENT_BUS.post((Event)(preEvent = new TeleportItemEvent.Pre(stack, player, this.world, teleportPosition, !player.m_7500_(), this.teleportToSpawnpoint)))) {
                if (preEvent.shouldTeleportToSpawnpoint()) {
                    preEvent.setTeleportPosition(this.getSpawnpoint(serverPlayer, preEvent));
                }
                DimensionHelper.teleport((ServerPlayer)preEvent.getPlayer(), preEvent.getLevel(), preEvent.getTeleportPosition().m_123341_(), preEvent.getTeleportPosition().m_123342_(), preEvent.getTeleportPosition().m_123343_());
                if (preEvent.shouldConsumeItemStack()) {
                    stack.m_41774_(1);
                }
                Pixelmon.EVENT_BUS.post((Event)new TeleportItemEvent.Post(preEvent.getItemStack(), preEvent.getPlayer(), preEvent.getLevel(), preEvent.getTeleportPosition(), preEvent.shouldConsumeItemStack(), preEvent.shouldTeleportToSpawnpoint()));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private BlockPos getSpawnpoint(ServerPlayer player, TeleportItemEvent.Pre event) {
        if (player.m_8961_() != null) {
            if (player.m_8963_() != null) {
                event.setLevel(player.m_8963_().m_135782_().toString());
            }
            return player.m_8961_();
        }
        return player.m_21257_().orElse(event.getActualLevel().map(Level::m_220360_).orElse(player.m_20183_()));
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.foil;
    }
}

