/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.TMType;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class TechnicalMoveItem
extends PixelmonItem {
    private final TMType prefix;

    public TechnicalMoveItem(TMType prefix) {
        super(new Item.Properties());
        this.prefix = prefix;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.f_46443_) {
            if (TechnicalMoveItem.getMove(stack) == null) {
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128376_("tm", (short)stack.m_41773_());
                if (TechnicalMoveItem.getMove(stack) == null) {
                    stack.m_41783_().m_128376_("tm", (short)RandomHelper.getRandomElementFromArray(ITechnicalMove.getAllFor(this.prefix)).getId());
                }
            }
            if (stack.m_41773_() != 0) {
                stack.m_41721_(0);
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public String m_5671_(ItemStack stack) {
        ITechnicalMove technicalMove = TechnicalMoveItem.getMove(stack);
        if (technicalMove == null) {
            return super.m_5671_(stack);
        }
        return "item.pixelmon." + ForgeRegistries.ITEMS.getKey((Object)this).m_135815_() + "." + technicalMove.getId();
    }

    @Override
    public String getTooltipText(ItemStack stack) {
        Object ret = "";
        ITechnicalMove technicalMove = TechnicalMoveItem.getMove(stack);
        if (technicalMove == null) {
            return ret;
        }
        ImmutableAttack ab = technicalMove.getAttack();
        if (ab == null || !ab.isAttack(technicalMove.getAttack())) {
            return ret;
        }
        String formattedData = I18n.m_118938_((String)"tm.movedata.tooltip", (Object[])new Object[]{"&" + String.format("#%06X", 0xFFFFFF & ab.getAttackType().getColor()) + ab.getAttackType().getLocalizedName() + ChatFormatting.GRAY, ab.getBasePower() != 0 ? Integer.valueOf(ab.getBasePower()) : "-", ab.getAccuracy() != -1 ? Integer.valueOf(ab.getAccuracy()) : "-", ab.getPPBase()});
        ret = (String)ret + formattedData;
        if (I18n.m_118936_((String)(this.m_5524_() + ".tooltip"))) {
            ret = (String)ret + I18n.m_118938_((String)(this.m_5524_() + ".tooltip"), (Object[])new Object[0]);
        }
        return ret;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag compound = super.getShareTag(stack);
        if (compound != null && compound.m_128441_("tm")) {
            compound.m_128405_("tm", (int)compound.m_128448_("tm"));
        }
        return compound;
    }

    public String type() {
        return this.prefix.name();
    }

    @Nullable
    public static ITechnicalMove getMove(ItemStack stack) {
        if (stack.m_41720_() instanceof TechnicalMoveItem && stack.m_41782_()) {
            short id = stack.m_41783_().m_128448_("tm");
            return ITechnicalMove.getMoveFor(((TechnicalMoveItem)stack.m_41720_()).prefix, id);
        }
        return null;
    }

    @Nullable
    public static ITechnicalMove getInstanceOf(ItemStack stack) {
        if (stack.m_41720_() instanceof TechnicalMoveItem) {
            return ITechnicalMove.getMoveFor(((TechnicalMoveItem)stack.m_41720_()).prefix, 0);
        }
        return null;
    }

    public static ItemStack of(TMType type, ITechnicalMove move) {
        ItemStack stack = new ItemStack((ItemLike)type.getItem());
        stack.m_41751_(new CompoundTag());
        stack.m_41783_().m_128376_("tm", (short)move.getId());
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class TMPropertyGetter
    implements ItemPropertyFunction {
        public static final TMPropertyGetter INSTANCE = new TMPropertyGetter();

        public float m_141951_(ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int i) {
            ITechnicalMove move = TechnicalMoveItem.getMove(stack);
            if (move == null || move.getAttack() == null || move.getAttack().getAttackType() == null) {
                return 0.0f;
            }
            return move.getAttack().getAttackType().getIndex();
        }
    }
}

