/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.Palette;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonPalettes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpriteItem
extends PixelmonItem
implements IEquippable {
    public SpriteItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public Component m_7626_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return super.m_7626_(stack);
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_("Nickname")) {
            return Component.m_237113_((String)(tag.m_128461_("Nickname") + " " + this.getLocalizedName()));
        }
        if (tag.m_128471_("isEgg") || tag.m_128451_("eggCycles") > 0) {
            return Component.m_237115_((String)"pixelmon.egg");
        }
        if (tag.m_128441_("ndex")) {
            Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(tag.m_128448_("ndex")));
            if (species == null) {
                return super.m_7626_(stack);
            }
            Stats form = species.getForm(tag.m_128461_("form"));
            Palette palette = PixelmonPalettes.fromName(tag.m_128461_("palette"));
            PaletteProperties paletteProperties = this.getPalettePropertiesFromName(form, palette.getName());
            if (form == null || paletteProperties == null) {
                return super.m_7626_(stack);
            }
            Object name = species.getLocalizedName();
            if (form.isForm("mega", "megax", "megay", "primal", "alolan", "galarian") && !form.isDefault()) {
                name = form.getLocalizedName() + " " + (String)name;
            }
            if (!paletteProperties.getName().equalsIgnoreCase("none")) {
                name = paletteProperties.getLocalizedName() + " " + (String)name;
            }
            return Component.m_237110_((String)"item.pixelmon.pixelmon_sprite", (Object[])new Object[]{name});
        }
        return super.m_7626_(stack);
    }

    @Override
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public PaletteProperties getPalettePropertiesFromName(Stats form, String name) {
        for (Gender gender : form.getPossibleGenders()) {
            for (PaletteProperties paletteProperties : form.getGenderProperties(gender).getPalettes()) {
                if (!paletteProperties.getName().equals(name)) continue;
                return paletteProperties;
            }
        }
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.HEAD && stack.m_41782_() && !stack.m_41783_().m_128471_("Unequippable");
    }

    @Override
    public String getEquippableModelKey() {
        return "pixelmon_sprite";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }
}

