/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RubyItem
extends PixelmonItem {
    public RubyItem() {
        super(new Item.Properties());
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_) {
            ServerPlayer playerMP = (ServerPlayer)player;
            if (entity instanceof PixelmonEntity) {
                PixelmonEntity pixelmon = (PixelmonEntity)entity;
                Species lakeGuardian = pixelmon.getSpecies();
                if (!(pixelmon.isPokemon(PixelmonSpecies.AZELF) || pixelmon.isPokemon(PixelmonSpecies.MESPRIT) || pixelmon.isPokemon(PixelmonSpecies.UXIE))) {
                    return false;
                }
                if (pixelmon.isOwnedBy((LivingEntity)player)) {
                    LakeTrioStats lakeTrioStats = (LakeTrioStats)pixelmon.getPokemon().getExtraStats();
                    if (lakeTrioStats.numEnchanted < PixelmonConfigProxy.getGeneral().getLakeTrioMaxEnchants()) {
                        if (pixelmon.getPokemon().getFriendship() >= 255) {
                            if (pixelmon.getLvl().getPokemonLevel() >= 60) {
                                ++lakeTrioStats.numEnchanted;
                                pixelmon.getLvl().setLevel(pixelmon.getLvl().getPokemonLevel() / 2 + 10);
                                pixelmon.getPokemon().setFriendship(200);
                                ChatHandler.sendFormattedChat((CommandSource)playerMP, ChatFormatting.GREEN, "ruby.success", pixelmon.getNickname());
                                pixelmon.update(EnumUpdateType.Stats);
                                pixelmon.update(EnumUpdateType.Friendship);
                                PixelmonItem fromGuardian = PixelmonItems.getRubyFromGuardian(pixelmon.getSpecies());
                                if (fromGuardian != null) {
                                    stack.m_41774_(1);
                                    DropItemHelper.giveItemStack(playerMP, new ItemStack((ItemLike)fromGuardian), false);
                                }
                            } else {
                                ChatHandler.sendFormattedChat((CommandSource)playerMP, ChatFormatting.GRAY, "ruby.fail.pokemonLevel", pixelmon.getNickname());
                            }
                        } else {
                            ChatHandler.sendFormattedChat((CommandSource)playerMP, ChatFormatting.GRAY, "ruby.fail.happiness", pixelmon.getNickname());
                        }
                    } else {
                        ChatHandler.sendFormattedChat((CommandSource)playerMP, ChatFormatting.GRAY, "ruby.fail.count", pixelmon.getNickname());
                    }
                } else {
                    ChatHandler.sendFormattedChat((CommandSource)playerMP, ChatFormatting.GRAY, "ruby.fail.owner", pixelmon.getNickname());
                }
            }
        }
        return false;
    }
}

