/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.CheckPokemonEditorAllowedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.SetEditedPlayerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateSinglePokemonPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PokemonEditorItem
extends PixelmonItem {
    public PokemonEditorItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_7500_() && hand == InteractionHand.MAIN_HAND && PokemonEditorItem.checkPermission((ServerPlayer)player)) {
            ServerPlayer playerMP = (ServerPlayer)player;
            PlayerPartyStorage party = StorageProxy.getPartyNow(playerMP);
            party.retrieveAll("PokemonEditor");
            NetworkHelper.sendPacket(new SetEditedPlayerPacket(player.m_20148_(), player.m_5446_().getString(), party.getAll()), playerMP);
            OpenScreenPacket.open(player, EnumGuiScreen.PokemonEditor, new int[0]);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof ServerPlayer && player.m_7500_()) {
            if (PokemonEditorItem.checkPermission((ServerPlayer)player)) {
                ServerPlayer otherPlayer = (ServerPlayer)entity;
                PlayerPartyStorage party = StorageProxy.getPartyNow(otherPlayer);
                if (party.guiOpened) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.general.playerbusy", new Object[0]);
                    return true;
                }
                NetworkHelper.sendPacket(new CheckPokemonEditorAllowedPacket(player.m_20148_()), otherPlayer);
            }
            return true;
        }
        return false;
    }

    public static void updateEditedPlayer(ServerPlayer editingPlayer, UUID editedPlayer) {
        if (!PokemonEditorItem.checkPermission(editingPlayer)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(editedPlayer);
        NetworkHelper.sendPacket(new SetEditedPlayerPacket(editedPlayer, party.getAll()), editingPlayer);
    }

    public static void updateSinglePokemon(ServerPlayer editingPlayer, UUID editedPlayer, int slot) {
        if (!PokemonEditorItem.checkPermission(editingPlayer)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getPartyNow(editedPlayer);
        Pokemon pokemonData = party.get(slot);
        NetworkHelper.sendPacket(new UpdateSinglePokemonPacket(slot, pokemonData), editingPlayer);
    }

    public static boolean checkPermission(ServerPlayer editingPlayer) {
        if (PixelmonConfigProxy.getGeneral().isAllowPokemonEditors() && PlayerHelper.hasPermission(editingPlayer, "pixelmon.pokemoneditor.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)editingPlayer, "gui.pokemoneditor.notallowedserver", new Object[0]);
        return false;
    }
}

