/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.events.ThrowPokeballEvent;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.client.models.items.PixelmonBEWLRs;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokeBallIdPacket;
import com.pixelmonmod.pixelmon.entities.pokeballs.EmptyPokeBallEntity;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.PokeBallPart;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;

public class PokeBallItem
extends PixelmonItem
implements PokeBallPart {
    private static final MutableComponent UNKNOWN_BALL = Component.m_237115_((String)"item.pixelmon.unknown_poke_ball");

    public PokeBallItem() {
        super(new Item.Properties(), PixelmonBEWLRs.POKE_BALL_ISTER);
    }

    public static ItemStack of(PokeBall pokeBall) {
        return PokeBallItem.of(pokeBall, 1);
    }

    public static ItemStack of(PokeBall pokeBall, int count) {
        ItemStack stack = new ItemStack((ItemLike)PixelmonItems.poke_ball, count);
        stack.m_41751_(new CompoundTag());
        stack.m_41783_().m_128359_("PokeBallID", pokeBall.getName());
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        return (Component)PokeBallPart.getPokeBall(stack).map(ITranslatable::getTranslatedName).orElse(UNKNOWN_BALL);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entityPlayer, InteractionHand handIn) {
        ItemStack itemStack = entityPlayer.m_21120_(handIn);
        Optional<PokeBall> pokeBall = PokeBallPart.getPokeBall(itemStack);
        if (pokeBall.isPresent()) {
            ThrowPokeballEvent throwPokeBallEvent = new ThrowPokeballEvent(entityPlayer, itemStack, pokeBall.get(), false);
            if (Pixelmon.EVENT_BUS.post((Event)throwPokeBallEvent)) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
            }
            if (PixelmonServerConfig.allowCapturingOutsideBattle) {
                world.m_5594_(null, entityPlayer.m_20183_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                if (!world.f_46443_) {
                    world.m_7967_((Entity)new EmptyPokeBallEntity(world, (LivingEntity)entityPlayer, pokeBall.get(), !entityPlayer.m_7500_()));
                    if (!entityPlayer.m_7500_()) {
                        itemStack.m_41774_(1);
                        entityPlayer.m_150109_().m_6596_();
                    }
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        ServerPlayer thrower = userWrapper.getPlayerOwner();
        if (!(targetWrapper.getParticipant() instanceof WildPixelmonParticipant)) {
            return false;
        }
        Optional<PokeBall> pokeBall = PokeBallPart.getPokeBall(stack);
        if (!pokeBall.isPresent()) {
            return false;
        }
        ThrowPokeballEvent throwPokeballEvent = new ThrowPokeballEvent((Player)thrower, null, pokeBall.get(), true);
        Pixelmon.EVENT_BUS.post((Event)throwPokeballEvent);
        Level world = thrower.f_19853_;
        EmptyPokeBallEntity p = new EmptyPokeBallEntity(world, (LivingEntity)thrower, targetWrapper.entity, pokeBall.get(), BattleRegistry.getBattle((Player)thrower));
        world.m_7967_((Entity)p);
        userWrapper.bc.sendToPlayers(new SetPokeBallIdPacket(p.m_19879_()));
        return super.useFromBag(userWrapper, targetWrapper, stack);
    }

    @Override
    public String getTooltipText(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("tooltip")) {
            return nbt.m_128461_("tooltip");
        }
        return this.getTooltipText(PokeBallPart.getPokeBall(stack).map(pokeBall -> pokeBall.getTranslationKey() + ".tooltip").orElse(""));
    }

    public String getTooltipText(String key) {
        if (!key.isEmpty() && I18n.m_118936_((String)key)) {
            return I18n.m_118938_((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237113_((String)"[\u2c10\u2517\u2739\u2ae2\u2175\u2cb5\u227c\u2d64\u2363\u2810\u21c6] Poke Ball"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if (!stack.m_41783_().m_128441_("PokeBallID")) {
            stack.m_41783_().m_128359_("PokeBallID", PokeBallRegistry.POKE_BALL.getKey());
        }
    }
}

