/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.container.PokeBagContainer;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PokeBagItem
extends PixelmonItem
implements IEquippable {
    private final DyeColor color;

    public PokeBagItem(DyeColor color) {
        super(new Item.Properties().m_41487_(1));
        this.color = color;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            PokeBagItem.openPokeBag(stack, (ServerPlayer)player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public String getTooltipText() {
        return I18n.m_118938_((String)"item.pixelmon.pokebag.tooltip", (Object[])new Object[0]);
    }

    @Override
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @Override
    public String getEquippableModelKey() {
        return "badgecase";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public static void openPokeBag(final ItemStack stack, final ServerPlayer player) {
        if (stack.m_41720_() instanceof PokeBagItem) {
            final PokeBag pokeBag = PokeBag.readFromItemStack((Player)player, stack);
            SimpleMenuProvider containerProvider = new SimpleMenuProvider((a, b, c) -> new PokeBagContainer(a, player.m_150109_(), pokeBag), (Component)Component.m_237119_());
            if (!player.m_150109_().m_36063_(stack)) {
                return;
            }
            player.openMenu((MenuProvider)containerProvider, pokeBag::writeToBuffer);
            player.f_36096_.m_38893_(new ContainerListener(){

                public void m_7934_(AbstractContainerMenu container, int slot, ItemStack item) {
                    if (!player.m_150109_().m_36063_(stack)) {
                        return;
                    }
                    if (slot >= pokeBag.inventory.m_6643_()) {
                        return;
                    }
                    pokeBag.inventory.m_6836_(slot, item);
                    pokeBag.writeToStack(stack);
                }

                public void m_142153_(AbstractContainerMenu p_71112_1_, int p_71112_2_, int p_71112_3_) {
                    if (!player.m_150109_().m_36063_(stack)) {
                        return;
                    }
                    pokeBag.writeToStack(stack);
                }
            });
        }
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return (!stack.m_41782_() || !stack.m_41783_().m_128471_("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }

    public static Item getItem(DyeColor dyeColor) {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)("pixelmon:" + dyeColor.m_41065_() + "_poke_bag")));
    }

    public static class PokeBag {
        public Container inventory;
        private int slot;
        public DyeColor color;

        public PokeBag(Container inventory, DyeColor color, int slot) {
            this.inventory = inventory;
            this.color = color;
            this.slot = slot;
        }

        public int getSlot() {
            return this.slot;
        }

        public void writeToStack(ItemStack stack) {
            CompoundTag compound = stack.m_41784_();
            this.saveInventory(compound);
            compound.m_128405_("PokeBagColor", this.color.ordinal());
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = new CompoundTag();
            this.saveInventory(compound);
            buffer.m_130079_((Tag)compound);
            buffer.writeInt(this.color.m_41060_());
            buffer.writeInt(this.slot);
        }

        public void saveInventory(CompoundTag CompoundTag2) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", i);
                nbt.m_128365_("item", (Tag)this.inventory.m_8020_(i).m_41739_(new CompoundTag()));
                list.add((Object)nbt);
            }
            CompoundTag2.m_128365_("PokeBagItems", (Tag)list);
        }

        public static Container fromTag(CompoundTag nbt) {
            ListTag list = nbt.m_128437_("PokeBagItems", 10);
            SimpleContainer inventory = new SimpleContainer(27);
            for (Tag inbt : list) {
                CompoundTag listNBT = (CompoundTag)inbt;
                inventory.m_6836_(listNBT.m_128451_("slot"), ItemStack.m_41712_((CompoundTag)listNBT.m_128469_("item")));
            }
            return inventory;
        }

        public static PokeBag readFromItemStack(Player player, ItemStack stack) {
            if (!(stack.m_41720_() instanceof PokeBagItem)) {
                return null;
            }
            CompoundTag compound = stack.m_41783_();
            SimpleContainer inventory = new SimpleContainer(27);
            if (compound != null && compound.m_128441_("PokeBagItems")) {
                inventory = PokeBag.fromTag(compound);
            }
            DyeColor color = DyeColor.RED;
            if (compound != null) {
                color = DyeColor.m_41053_((int)compound.m_128451_("PokeBagColor"));
            }
            int slot = -1;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!Objects.equals(item, stack)) continue;
                slot = i;
                break;
            }
            PokeBag pokeBag = new PokeBag((Container)inventory, color, slot);
            return pokeBag;
        }

        public static PokeBag fromBuffer(FriendlyByteBuf buffer) {
            CompoundTag compound = buffer.m_130260_();
            Container inventory = PokeBag.fromTag(compound);
            return new PokeBag(inventory, DyeColor.m_41053_((int)buffer.readInt()), buffer.readInt());
        }

        public Container getInventory() {
            return this.inventory;
        }
    }
}

