/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.items.BEWLRCallable;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class PixelmonItem
extends Item {
    private boolean hasEffect = false;
    private boolean isDrink = false;
    private boolean tempt = false;
    private boolean searchable = true;
    protected BEWLRCallable bewlr;

    public PixelmonItem(Item.Properties properties) {
        super(properties);
    }

    public PixelmonItem(Item.Properties properties, BEWLRCallable bewlr) {
        this(properties);
        try {
            this.bewlr = bewlr;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PixelmonItem setDrink() {
        this.isDrink = true;
        return this;
    }

    public PixelmonItem setTempt() {
        this.tempt = true;
        return this;
    }

    public boolean m_41472_() {
        return this.m_41473_() != null;
    }

    public boolean isDrink() {
        return this.isDrink;
    }

    public PixelmonItem setHasEffect(boolean hasEffect) {
        this.hasEffect = hasEffect;
        return this;
    }

    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack) {
        ServerPlayer player = pixelmonWrapper.getPlayerOwner();
        if (player != null) {
            return !player.m_7500_();
        }
        return false;
    }

    public boolean useFromBag(PixelmonWrapper pixelmonWrapper, PixelmonWrapper target, ItemStack stack, int additionalInfo) {
        return this.useFromBag(pixelmonWrapper, target, stack);
    }

    public String getLocalizedName() {
        return Component.m_237115_((String)this.m_5524_()).getString();
    }

    public boolean m_5812_(ItemStack itemstack) {
        if (itemstack.m_41782_() && itemstack.m_41783_().m_128441_("HasEffect")) {
            return true;
        }
        return this.hasEffect || itemstack.m_41793_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        String tt = this.getTooltipText(stack);
        if (!tt.isEmpty()) {
            if (ScreenHelper.isKeyDown(340)) {
                for (String s : tt.split("\n")) {
                    tooltip.add(TextHelper.colour(ChatFormatting.GRAY + s));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"gui.tooltip.collapsed", (Object[])new Object[0]))));
            }
        }
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public String getTooltipText(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("tooltip")) {
            return nbt.m_128461_("tooltip");
        }
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (I18n.m_118936_((String)(this.m_5524_() + ".tooltip"))) {
            return I18n.m_118938_((String)(this.m_5524_() + ".tooltip"), (Object[])new Object[0]);
        }
        return "";
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.m_41472_()) {
            return UseAnim.EAT;
        }
        if (this.isDrink()) {
            return UseAnim.DRINK;
        }
        return super.m_6164_(stack);
    }

    public boolean causeTempt() {
        return this.tempt;
    }

    public PixelmonItem hideFromSearches() {
        this.searchable = false;
        return this;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                try {
                    return PixelmonItem.this.bewlr == null ? super.getCustomRenderer() : PixelmonItem.this.bewlr.call();
                }
                catch (Exception e) {
                    return super.getCustomRenderer();
                }
            }
        });
    }
}

