/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PixelmonBootsItem
extends ArmorItem {
    private static final UUID RUNNING_SHOES_UUID = UUID.fromString("B7060ADF-8FAF-4C0F-B816-87CB5721979F");
    private static final AttributeModifier OLD_RUNNING_SHOES_MODIFIER = new AttributeModifier(RUNNING_SHOES_UUID, Attributes.f_22279_.m_22087_(), 0.5, AttributeModifier.Operation.m_22236_((int)1));
    private static final AttributeModifier NEW_RUNNING_SHOES_MODIFIER = new AttributeModifier(RUNNING_SHOES_UUID, Attributes.f_22279_.m_22087_(), 0.75, AttributeModifier.Operation.m_22236_((int)1));

    public PixelmonBootsItem(ArmorMaterial materialIn, ArmorItem.Type type) {
        super(materialIn, type, new Item.Properties().m_41503_(1000));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot != EquipmentSlot.FEET) {
            return ImmutableMultimap.of();
        }
        HashMultimap o = HashMultimap.create();
        if (slot == EquipmentSlot.FEET) {
            AttributeModifier modifier = this == PixelmonItems.old_running_boots ? OLD_RUNNING_SHOES_MODIFIER : NEW_RUNNING_SHOES_MODIFIER;
            o.put((Object)Attributes.f_22279_, (Object)modifier);
        }
        return o;
    }

    public void onArmorTick(ItemStack itemStack, Level world, Player player) {
        if (!world.f_46443_ && itemStack != null && player.m_6844_(EquipmentSlot.FEET) == itemStack) {
            Item item = itemStack.m_41720_();
            if (item == PixelmonItems.new_running_boots) {
                if (!itemStack.m_41763_()) {
                    if (itemStack.m_41768_()) {
                        itemStack.m_41721_(0);
                    }
                    return;
                }
                if (player.m_7500_() || player.m_5833_() || player.m_20202_() != null || player.m_21255_()) {
                    return;
                }
                int maxDamage = PixelmonItems.new_running_boots.getMaxDamage(itemStack);
                if (itemStack.m_41773_() >= maxDamage) {
                    player.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)PixelmonItems.old_running_boots));
                } else {
                    double currentX = player.m_20185_();
                    double currentZ = player.m_20189_();
                    CompoundTag compound = itemStack.m_41698_("pos");
                    if (!compound.m_128441_("x")) {
                        compound.m_128347_("x", currentX);
                        compound.m_128347_("z", currentZ);
                        return;
                    }
                    double bootLastX = compound.m_128459_("x");
                    double bootLastZ = compound.m_128459_("z");
                    double changeX = Math.abs(bootLastX - currentX);
                    double changeZ = Math.abs(bootLastZ - currentZ);
                    if (changeX >= 2.0 || changeZ >= 2.0) {
                        itemStack.m_41721_(itemStack.m_41773_() + 1);
                        compound.m_128347_("x", currentX);
                        compound.m_128347_("z", currentZ);
                    }
                }
            } else if (item == PixelmonItems.old_running_boots && itemStack.m_41768_()) {
                itemStack.m_41721_(0);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (stack.m_41720_() == PixelmonItems.new_running_boots) {
            return "pixelmon:textures/models/armor/running_1.png";
        }
        return "pixelmon:textures/models/armor/oldrunning_1.png";
    }
}

