/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.blocks.IBlockHasOwner;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.enums.MultiBlockPosition;
import com.pixelmonmod.pixelmon.blocks.furniture.ArmchairBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.BoxBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.ChairBlock;
import com.pixelmonmod.pixelmon.blocks.furniture.CushionChairBlock;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.models.items.BEWLRCallable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PixelmonBlockItem
extends BlockItem {
    private final Supplier<BEWLRCallable> bewlr;

    public PixelmonBlockItem(Block block, Item.Properties properties) {
        this(block, properties, null);
    }

    public PixelmonBlockItem(Block block, Item.Properties properties, Supplier<BEWLRCallable> bewlr) {
        super(block, properties);
        this.bewlr = bewlr;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        ItemStack stack = player.m_21120_(hand);
        BlockState iBlockState = worldIn.m_8055_(pos);
        Block placedOn = iBlockState.m_60734_();
        BlockPlaceContext blockUseOnContext = new BlockPlaceContext(context);
        boolean canBeReplaced = placedOn.m_6864_(worldIn.m_8055_(pos), blockUseOnContext);
        if (placedOn == Blocks.f_50125_ && (Integer)iBlockState.m_61143_((Property)SnowLayerBlock.f_56581_) < 1) {
            facing = Direction.UP;
        } else if (!canBeReplaced) {
            pos = pos.m_121945_(facing);
        }
        if (stack.m_41613_() == 0) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(pos, facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (pos.m_123342_() == 255 && iBlockState.m_280296_()) {
            return InteractionResult.FAIL;
        }
        Direction rot = context.m_8125_();
        if (!worldIn.m_46859_(pos) && !canBeReplaced || worldIn.m_8055_(pos.m_7495_()).m_60734_() == this.m_40614_()) return InteractionResult.FAIL;
        if (this.m_40614_() instanceof MultiBlock) {
            if (!PixelmonBlockItem.canPlace(pos, rot, worldIn, (MultiBlock)this.m_40614_(), player, stack, placedOn)) return InteractionResult.FAIL;
            MultiBlock mb = (MultiBlock)this.m_40614_();
            BlockState iblockstate1 = this.m_40614_().m_5573_(blockUseOnContext);
            this.placeBlock(stack, iblockstate1, player, worldIn, pos);
            PixelmonBlockItem.setMultiBlocksWidth(pos, rot, worldIn, mb, this.m_40614_(), player);
            this.playPlacementSound(worldIn, pos, player);
        } else {
            BlockState iblockstate1 = this.m_40614_().m_5573_(blockUseOnContext);
            if (iblockstate1 == null) {
                return InteractionResult.FAIL;
            }
            BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)worldIn.m_46472_(), (LevelAccessor)worldIn, (BlockPos)pos), iBlockState, (Entity)player);
            MinecraftForge.EVENT_BUS.post((Event)placeEvent);
            if (placeEvent.isCanceled()) {
                return InteractionResult.FAIL;
            }
            if (this.placeBlock(stack, iblockstate1, player, worldIn, pos)) {
                this.playPlacementSound(worldIn, pos, player);
            }
        }
        if (this.m_40614_() instanceof IBlockHasOwner) {
            ((IBlockHasOwner)this.m_40614_()).setOwner(pos, player);
        }
        if (player.m_7500_()) return InteractionResult.SUCCESS;
        stack.m_41764_(stack.m_41613_() - 1);
        return InteractionResult.SUCCESS;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return super.canEquip(stack, armorType, entity) || armorType == EquipmentSlot.HEAD && (this.m_40614_() instanceof CushionChairBlock || this.m_40614_() instanceof BoxBlock || this.m_40614_() instanceof ChairBlock || this.m_40614_() instanceof ArmchairBlock);
    }

    private boolean placeBlock(ItemStack stack, BlockState newState, Player player, Level world, BlockPos pos) {
        if (!world.m_7731_(pos, newState, 3)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this.m_40614_()) {
            PixelmonBlockItem.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)stack);
            this.m_40614_().m_6402_(world, pos, state, (LivingEntity)player, stack);
        }
        return true;
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState p_195944_2_) {
        if (this.m_40614_() instanceof MultiBlock) {
            MultiBlock mb = (MultiBlock)this.m_40614_();
            BlockPos pos2 = context.m_8083_().m_121945_(context.m_43719_());
            return PixelmonBlockItem.canPlace(pos2, context.m_43723_().m_6350_(), context.m_43725_(), mb, context.m_43723_(), context.m_43722_(), context.m_43725_().m_8055_(pos2).m_60734_());
        }
        return super.m_40610_(context, p_195944_2_);
    }

    public static boolean canPlace(BlockPos pos, Direction rot, Level world, MultiBlock mb, Player player, ItemStack stack, Block block) {
        int x;
        int n = rot == Direction.NORTH ? 1 : (x = rot == Direction.SOUTH ? -1 : 0);
        int z = rot == Direction.EAST ? 1 : (rot == Direction.WEST ? -1 : 0);
        for (int l = PixelmonBlockItem.getWidthOffset(mb); l < mb.getWidth() + PixelmonBlockItem.getWidthOffset(mb); ++l) {
            if (PixelmonBlockItem.canPlaceLength(pos, x * l, z * l, rot, world, mb, player, stack, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean canPlaceLength(BlockPos pos, int xd, int zd, Direction rot, Level world, MultiBlock mb, Player player, ItemStack stack, Block block) {
        int x;
        int n = rot == Direction.EAST ? 1 : (x = rot == Direction.WEST ? -1 : 0);
        int z = rot == Direction.NORTH ? -1 : (rot == Direction.SOUTH ? 1 : 0);
        for (int w = 0; w < mb.getLength(); ++w) {
            if (PixelmonBlockItem.canPlaceHeight(pos, xd + w * x, zd + w * z, rot, world, mb, player, stack, block)) continue;
            return false;
        }
        return true;
    }

    private static boolean canPlaceHeight(BlockPos pos, int xd, int zd, Direction rot, Level world, MultiBlock mb, Player player, ItemStack stack, Block block) {
        int h = 0;
        while ((double)h < mb.getHeight()) {
            BlockPos p = new BlockPos(pos.m_123341_() + xd, pos.m_123342_() + h, pos.m_123343_() + zd);
            BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)p), world.m_8055_(p.m_7495_()), (Entity)player);
            MinecraftForge.EVENT_BUS.post((Event)placeEvent);
            if (placeEvent.isCanceled()) {
                return false;
            }
            BlockState iblockstate = world.m_8055_(p);
            if (!iblockstate.m_204336_(BlockTags.f_278394_) && !iblockstate.m_60713_(Blocks.f_50016_)) {
                return false;
            }
            ++h;
        }
        return true;
    }

    public static void setMultiBlocksWidth(BlockPos pos, Direction rot, Level world, MultiBlock mb, Block block, Player player) {
        int x;
        int n = rot == Direction.NORTH ? 1 : (x = rot == Direction.SOUTH ? -1 : 0);
        int z = rot == Direction.EAST ? 1 : (rot == Direction.WEST ? -1 : 0);
        for (int l = PixelmonBlockItem.getWidthOffset(mb); l < mb.getWidth() + PixelmonBlockItem.getWidthOffset(mb); ++l) {
            PixelmonBlockItem.setMultiBlocksLength(pos, x * l, z * l, rot, world, mb, block, player);
        }
    }

    public static int getWidthOffset(MultiBlock mb) {
        return mb.getJsonOffset() ? -1 : 0;
    }

    private static void setMultiBlocksLength(BlockPos pos, int xd, int zd, Direction rot, Level world, MultiBlock mb, Block block, Player player) {
        int x;
        int n = rot == Direction.EAST ? 1 : (x = rot == Direction.WEST ? -1 : 0);
        int z = rot == Direction.NORTH ? -1 : (rot == Direction.SOUTH ? 1 : 0);
        for (int w = 0; w < mb.getLength(); ++w) {
            PixelmonBlockItem.setMultiBlocksHeight(pos, xd + w * x, zd + w * z, rot, world, mb, block, player);
        }
    }

    private static void setMultiBlocksHeight(BlockPos pos, int xd, int zd, Direction rot, Level world, MultiBlock mb, Block block, Player player) {
        int h = 0;
        while ((double)h < mb.getHeight()) {
            BlockPos p = new BlockPos(pos.m_123341_() + xd, pos.m_123342_() + h, pos.m_123343_() + zd);
            Direction facing = xd > 0 ? Direction.EAST : (xd < 0 ? Direction.WEST : (zd > 0 ? Direction.SOUTH : (zd < 0 ? Direction.NORTH : rot)));
            MultiBlockPosition multiPos = xd == 0 && zd == 0 && h == 0 ? MultiBlockPosition.BASE : (h == 0 ? MultiBlockPosition.BOTTOM : MultiBlockPosition.TOP);
            BlockState iblockstate1 = (BlockState)((BlockState)block.m_49966_().m_61124_(MultiBlock.MULTIPOS, (Comparable)((Object)multiPos))).m_61124_((Property)MultiBlock.FACING, (Comparable)facing);
            world.m_7731_(p, iblockstate1, 2);
            ++h;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        String tt = this.getTooltipText(stack);
        if (!tt.isEmpty()) {
            if (ScreenHelper.isKeyDown(340)) {
                for (String s : tt.split("\n")) {
                    tooltip.add((Component)Component.m_237113_((String)s));
                }
            } else {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + I18n.m_118938_((String)"gui.tooltip.collapsed", (Object[])new Object[0]))));
            }
        }
        super.m_7373_(stack, world, tooltip, advanced);
    }

    public String getTooltipText(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("tooltip")) {
            return nbt.m_128461_("tooltip");
        }
        return this.getTooltipText();
    }

    public String getTooltipText() {
        if (I18n.m_118936_((String)(this.m_5524_() + ".tooltip"))) {
            return I18n.m_118938_((String)(this.m_5524_() + ".tooltip"), (Object[])new Object[0]);
        }
        return "";
    }

    private void playPlacementSound(Level worldIn, BlockPos pos, Player player) {
        SoundType soundType = worldIn.m_8055_(pos).m_60734_().getSoundType(worldIn.m_8055_(pos), (LevelReader)worldIn, pos, (Entity)player);
        worldIn.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                try {
                    return PixelmonBlockItem.this.bewlr == null ? super.getCustomRenderer() : PixelmonBlockItem.this.bewlr.get().call();
                }
                catch (Exception e) {
                    return super.getCustomRenderer();
                }
            }
        });
    }
}

