/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PPUpItem
extends PixelmonItem {
    private int ppLevel = 1;

    public PPUpItem(boolean maxPP) {
        super(new Item.Properties());
        if (maxPP) {
            this.ppLevel = 3;
        }
    }

    public static void handleMoveSelect(ServerPlayer player, UUID poke, int moveIndex) {
        Pokemon pokemon;
        Attack attack;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof PPUpItem)) {
            return;
        }
        PPUpItem ppUp = (PPUpItem)stack.m_41720_();
        PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
        int slot = storage.getSlot(poke);
        if (slot != -1 && storage.get(slot) != null && (attack = (pokemon = storage.get(slot)).getMoveset().get(moveIndex)) != null) {
            if (attack.getMove().getPPMax() <= attack.getMove().getPPBase()) {
                ChatHandler.sendChat((Entity)player, "pixelmon.interaction.ppatmax", new Object[0]);
                return;
            }
            int old = attack.getMaxPP();
            if (ppUp.ppLevel == 3 && attack.ppLevel < 3) {
                attack.ppLevel = ppUp.ppLevel;
                attack.pp += attack.getMaxPP() - old;
                pokemon.markDirty(EnumUpdateType.Moveset);
                ChatHandler.sendChat((Entity)player, "pixelmon.interaction.ppmax", attack.getMove().getTranslatedName());
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            } else if (ppUp.ppLevel == 1 && attack.ppLevel < 3) {
                attack.ppLevel += ppUp.ppLevel;
                attack.pp += attack.getMaxPP() - old;
                pokemon.markDirty(EnumUpdateType.Moveset);
                if (attack.ppLevel < 3) {
                    ChatHandler.sendChat((Entity)player, "pixelmon.interaction.ppup", attack.getMove().getTranslatedName());
                } else {
                    ChatHandler.sendChat((Entity)player, "pixelmon.interaction.ppmax", attack.getMove().getTranslatedName());
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.interaction.ppatmax", new Object[0]);
            }
        }
    }
}

