/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class NPCEditorItem
extends PixelmonItem {
    public NPCEditorItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (world.f_46443_ || !player.m_7500_() || context.m_43724_() != InteractionHand.MAIN_HAND || !NPCEditorItem.checkPermission(player)) {
            return InteractionResult.PASS;
        }
        if (context.m_43719_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        OpenScreenPacket.open(player, EnumGuiScreen.CreateNpc, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.f_19853_.f_46443_) {
            return super.onLeftClickEntity(stack, player, entity);
        }
        if (entity instanceof NPCEntity && NPCEditorItem.checkPermission(player)) {
            OpenScreenPacket.open(player, EnumGuiScreen.DeleteNpc, entity.m_19879_());
            return true;
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public static boolean checkPermission(Player player) {
        if (PixelmonConfigProxy.getGeneral().isNpcEditorOpOnly()) {
            if (!player.m_20194_().m_6846_().m_11303_(player.m_36316_())) {
                ChatHandler.sendChat((Entity)player, "pixelmon.general.needop", new Object[0]);
                return false;
            }
            return true;
        }
        return PlayerHelper.hasPermission((ServerPlayer)player, "pixelmon.npceditor.use");
    }
}

