/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class KeyItem
extends PixelmonItem {
    private final EnumKeyItem item;

    public KeyItem(EnumKeyItem item) {
        super(new Item.Properties().m_41487_(1));
        this.item = item;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_) {
            PlayerPartyStorage pps = StorageProxy.getPartyNow(playerIn.m_20148_());
            boolean given = false;
            switch (this.item) {
                case KeyStone: {
                    if (pps.getMegaItemsUnlocked().canMega()) break;
                    pps.unlockMega(true);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.MegaItem, new int[0]);
                    given = true;
                    break;
                }
                case WishingStar: {
                    if (pps.getMegaItemsUnlocked().canDynamax()) break;
                    pps.unlockDynamax(true);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.MegaItem, 1);
                    given = true;
                    break;
                }
                case OvalCharm: {
                    if (pps.getOvalCharm().isAvailable()) break;
                    pps.setOvalCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.OvalCharm, new int[0]);
                    given = true;
                    break;
                }
                case ShinyCharm: {
                    if (pps.getShinyCharm().isAvailable()) break;
                    pps.setShinyCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.ShinyCharm, new int[0]);
                    given = true;
                    break;
                }
                case ExpCharm: {
                    if (pps.getExpCharm().isAvailable()) break;
                    pps.setExpCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.ExpCharm, new int[0]);
                    given = true;
                    break;
                }
                case CatchingCharm: {
                    if (pps.getCatchingCharm().isAvailable()) break;
                    pps.setCatchingCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.CatchingCharm, new int[0]);
                    given = true;
                    break;
                }
                case MarkCharm: {
                    if (pps.getMarkCharm().isAvailable()) break;
                    pps.setMarkCharm(EnumFeatureState.Active);
                    OpenScreenPacket.open((Player)pps.getPlayer(), EnumGuiScreen.MarkCharm, new int[0]);
                    given = true;
                }
            }
            if (given) {
                if (!playerIn.m_7500_()) {
                    stack.m_41774_(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            playerIn.m_213846_((Component)Component.m_237115_((String)"pixelmon.items.alreadyhave").m_130940_(ChatFormatting.GRAY));
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public static enum EnumKeyItem {
        KeyStone("key_stone"),
        ShinyCharm("shiny_charm"),
        OvalCharm("oval_charm"),
        WishingStar("wishing_star"),
        ExpCharm("exp_charm"),
        CatchingCharm("catching_charm"),
        MarkCharm("mark_charm");

        private final String name;

        private EnumKeyItem(String name) {
            this.name = name;
        }
    }
}

