/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.enums.EnumPokechestVisibility;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeChestTileEntity;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFinderItem
extends PixelmonItem {
    private static final double RADIUS = 35.0;

    public ItemFinderItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(5));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_36335_().m_41524_((Item)this, 20);
        if (!world.f_46443_) {
            PokeChestTileEntity chest = BlockHelper.findClosestTileEntity(PokeChestTileEntity.class, (Entity)player, 35.0, p -> p.getVisibility() == EnumPokechestVisibility.Hidden);
            if (chest != null) {
                Direction direction = this.getDirection(player, chest.m_58899_());
                if (direction == Direction.NORTH) {
                    itemStack.m_41784_().m_128405_("Direction", 1);
                } else if (direction == Direction.SOUTH) {
                    itemStack.m_41784_().m_128405_("Direction", 2);
                } else if (direction == Direction.EAST) {
                    itemStack.m_41784_().m_128405_("Direction", 3);
                } else {
                    itemStack.m_41784_().m_128405_("Direction", 4);
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else {
                itemStack.m_41784_().m_128405_("Direction", 0);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    private Direction getDirection(Player player, BlockPos pos) {
        int x = (int)(player.m_20185_() - (double)pos.m_123341_());
        int z = (int)(player.m_20189_() - (double)pos.m_123343_());
        Direction direction = Math.abs(x) > Math.abs(z) ? (x > 0 ? Direction.WEST : Direction.EAST) : (z > 0 ? Direction.NORTH : Direction.SOUTH);
        Direction facing = player.m_6350_();
        if (facing == direction) {
            return Direction.NORTH;
        }
        if (facing.m_122424_() == direction) {
            return Direction.SOUTH;
        }
        if (facing.m_122427_() == direction) {
            return Direction.EAST;
        }
        return Direction.WEST;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class PropertyGetter
    implements ItemPropertyFunction {
        public static final PropertyGetter INSTANCE = new PropertyGetter();

        public float m_141951_(ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int i) {
            return stack.m_41782_() ? (float)Mth.m_14045_((int)stack.m_41783_().m_128451_("Direction"), (int)0, (int)4) : 0.0f;
        }
    }
}

