/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.DayCareConditionStatusResponsePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class IsiHourglassItem
extends PixelmonItem {
    private final HourGlassType type;

    public IsiHourglassItem(HourGlassType type) {
        super(new Item.Properties());
        this.type = type;
    }

    public HourGlassType getType() {
        return this.type;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        Player playerIn = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!playerIn.m_36204_(pos = pos.m_121945_(context.m_43719_()), facing, stack)) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41613_() <= 0) {
            return InteractionResult.FAIL;
        }
        if (worldIn.m_8055_(pos).m_60629_(new BlockPlaceContext(context))) {
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.ITEMS.getKey((Object)this))).m_5573_(new BlockPlaceContext(context));
            if (state == null) {
                return InteractionResult.FAIL;
            }
            worldIn.m_7731_(pos, state, 3);
            state = worldIn.m_8055_(pos);
            state.m_60734_().m_6402_(worldIn, pos, state, (LivingEntity)playerIn, stack);
            if (!playerIn.m_7500_()) {
                if (stack.m_41613_() <= 1) {
                    playerIn.m_21008_(hand, ItemStack.f_41583_);
                } else {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HourGlassType {
        COPPER{

            @Override
            public boolean handle(ServerPlayer player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.hasBreedingBegun()) {
                    return false;
                }
                DayCareCondition nextCondition = dayCareBox.getNextCondition();
                if (nextCondition == null) {
                    return false;
                }
                DayCareRequirement dayCareRequirement = nextCondition.getNextRequirement().orElse(null);
                if (dayCareRequirement == null) {
                    return false;
                }
                nextCondition.skipRequirement(dayCareRequirement);
                if (nextCondition.isComplete()) {
                    dayCareBox.completeCondition(nextCondition);
                    if (dayCareBox.canBreedingBegin()) {
                        dayCareBox.beginBreeding();
                    }
                }
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        SILVER{

            @Override
            public boolean handle(ServerPlayer player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || !dayCareBox.hasBreedingBegun() || dayCareBox.getPercentComplete() >= 100.0) {
                    return false;
                }
                dayCareBox.setHourglassesUsed(dayCareBox.getHourglassesUsed() + 1);
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        GOLD{

            @Override
            public boolean handle(ServerPlayer player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(player);
                PlayerDayCare dayCare = party.getDayCare();
                DayCareBox dayCareBox = dayCare.getOrCreateBox(boxes[clicked]).orElse(null);
                if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.getPercentComplete() >= 100.0) {
                    return false;
                }
                dayCareBox.complete();
                NetworkHelper.sendPacket(player, new DayCareConditionStatusResponsePacket(dayCareBox.getBoxId(), (Component)Component.m_237119_(), true));
                NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                return true;
            }
        }
        ,
        DIAMOND{

            @Override
            public boolean handle(ServerPlayer player, int clicked, int ... boxes) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(player);
                PlayerDayCare dayCare = party.getDayCare();
                for (int box : boxes) {
                    DayCareBox dayCareBox = dayCare.getOrCreateBox(box).orElse(null);
                    if (dayCareBox == null || dayCareBox.isEmpty() || dayCareBox.getPercentComplete() >= 100.0) continue;
                    dayCareBox.complete();
                    dayCareBox.getEgg().getStats().setIVs(new IVStore(31, 31, 31, 31, 31, 31));
                    dayCareBox.getEgg().setFriendship(255);
                    dayCareBox.getEgg().addRibbon(RibbonRegistry.DAY_CARE.getValueUnsafe());
                    party.setNeedsSaving();
                    NetworkHelper.sendPacket(player, new DayCareConditionStatusResponsePacket(dayCareBox.getBoxId(), (Component)Component.m_237119_(), true));
                    NetworkHelper.sendPacket(player, new UpdateDayCareBoxPacket(dayCareBox));
                }
                return true;
            }
        };


        public abstract boolean handle(ServerPlayer var1, int var2, int ... var3);
    }
}

