/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.projectiles.HookEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FishingRodItem
extends PixelmonItem {
    private EnumRodType rodType;

    public FishingRodItem(EnumRodType rodType) {
        super(new Item.Properties().m_41503_(rodType.maxDamage));
        this.rodType = rodType;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
        }
        if (playerIn.f_36083_ != null) {
            boolean canPull = true;
            if (playerIn.f_36083_.f_37094_ != null) {
                canPull = playerIn.f_36083_.f_37094_.m_6094_();
            }
            if (canPull) {
                int i = playerIn.f_36083_.m_37156_(playerIn.m_21120_(hand));
                playerIn.f_36083_ = null;
                playerIn.m_21120_(hand).m_41622_(i, (LivingEntity)playerIn, t -> {});
            }
        } else if (StorageProxy.getPartyNow(playerIn.m_20148_()).getTeam().stream().anyMatch(Pokemon::canBattle)) {
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_() + 0.5, playerIn.m_20189_(), (SoundEvent)SoundRegistration.POKEBALL_THROW.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            int rodLevel = -1;
            if (playerIn.m_21120_(hand).m_41782_() && playerIn.m_21120_(hand).m_41783_().m_128441_("rodQuality")) {
                rodLevel = playerIn.m_21120_(hand).m_41783_().m_128451_("rodQuality");
            }
            worldIn.m_7967_((Entity)new HookEntity(worldIn, playerIn, this.rodType, rodLevel));
        } else {
            ChatHandler.sendChat((Entity)playerIn, "pixelmon.projectiles.teamfainted", new Object[0]);
        }
        playerIn.m_6674_(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
    }

    public EnumRodType getRodType() {
        return this.rodType;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        int rodLevel = -1;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("rodQuality")) {
            rodLevel = stack.m_41783_().m_128451_("rodQuality");
        }
        if (rodLevel > -1 && this.rodType != EnumRodType.OasRod) {
            tooltip.add((Component)Component.m_237115_((String)("item.pixelmon." + this.rodType.name().toLowerCase(Locale.ROOT) + ".quality_" + rodLevel)));
        }
        super.m_7373_(stack, world, tooltip, advanced);
    }
}

