/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.client.listener.EscapeRopeClient;
import com.pixelmonmod.pixelmon.items.TeleporterItem;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EscapeRopeItem
extends TeleporterItem {
    public EscapeRopeItem() {
        super(new Item.Properties(), "overworld", true);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && !playerIn.m_21255_() && !playerIn.m_21224_()) {
            return EscapeRopeTask.add(playerIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            EscapeRopeTask.tick(event.side);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EscapeRopeTask.remove(event.getEntity().m_20148_(), false);
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EscapeRopeTask.remove(event.getEntity().m_20148_(), true);
    }

    public static class EscapeRopeTask {
        private static final Map<UUID, EscapeRopeUser> TICKDOWN = Maps.newHashMap();
        private static final AtomicReference<EscapeRopeUser> CLIENT_USER = new AtomicReference<Object>(null);
        private static final Set<UUID> TO_REMOVE = Sets.newConcurrentHashSet();
        private static final AtomicBoolean CLIENT_FLAG = new AtomicBoolean(false);
        private static final AtomicBoolean CLIENT_REVERSE_FLAG = new AtomicBoolean(false);

        private EscapeRopeTask() {
            throw new IllegalStateException("Cannot instantiate this class");
        }

        private static boolean add(Player player) {
            if (!TICKDOWN.containsKey(player.m_20148_()) || CLIENT_USER.get() == null) {
                if (FMLEnvironment.dist.isClient()) {
                    EscapeRopeClient.setPOV(true, true);
                    CLIENT_USER.set(new EscapeRopeUser(player));
                    CLIENT_FLAG.set(true);
                } else {
                    TICKDOWN.put(player.m_20148_(), new EscapeRopeUser(player));
                }
                return true;
            }
            return false;
        }

        private static void remove(UUID player, boolean skipAnimation) {
            TO_REMOVE.add(player);
            if (FMLEnvironment.dist.isClient() && EscapeRopeTask.clientFlag()) {
                CLIENT_FLAG.set(false);
                CLIENT_REVERSE_FLAG.set(!skipAnimation);
                if (skipAnimation) {
                    EscapeRopeClient.setPOV(false, true);
                    CLIENT_USER.set(null);
                }
            }
        }

        private static void tick(LogicalSide side) {
            for (UUID toRemove : TO_REMOVE) {
                TICKDOWN.remove(toRemove);
            }
            TO_REMOVE.clear();
            if (FMLEnvironment.dist.isClient()) {
                if (CLIENT_USER.get() != null && CLIENT_USER.get().tick(side) && !CLIENT_REVERSE_FLAG.get()) {
                    EscapeRopeTask.remove(Util.f_137441_, false);
                }
            } else {
                for (EscapeRopeUser user : TICKDOWN.values()) {
                    if (!user.tick(side)) continue;
                    EscapeRopeTask.remove(user.player.m_20148_(), false);
                }
            }
        }

        public static boolean clientFlag() {
            return CLIENT_FLAG.get() || EscapeRopeTask.clientReverseFlag();
        }

        public static boolean clientReverseFlag() {
            return CLIENT_REVERSE_FLAG.get();
        }

        public static void unsetClientReverseFlag() {
            EscapeRopeTask.remove(Util.f_137441_, true);
        }

        private static class EscapeRopeUser {
            private final Player player;
            private int ticks;

            private EscapeRopeUser(Player player) {
                this.player = player;
                this.ticks = 80;
            }

            private boolean tick(LogicalSide side) {
                boolean done;
                ItemStack stack = this.player.m_21205_();
                if (stack.m_41720_() != PixelmonItems.escape_rope || this.player.m_21224_() || this.player.m_5803_() || this.player.m_21255_() || BattleRegistry.getBattle(this.player) != null) {
                    return true;
                }
                if (FMLEnvironment.dist.isClient()) {
                    EscapeRopeClient.updatePOV();
                }
                boolean bl = done = --this.ticks <= 0;
                if (done && side.isServer()) {
                    if (!this.player.m_7500_()) {
                        this.player.m_21205_().m_41774_(1);
                    }
                    EscapeRopeItem item = (EscapeRopeItem)stack.m_41720_();
                    item.doTeleport(this.player, stack);
                }
                return done;
            }
        }
    }
}

