/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.medicine.MedicineStatus;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CurryDishItem
extends PixelmonItem {
    private static final MedicineStatus allStatuses = new MedicineStatus(StatusType.Burn, StatusType.Confusion, StatusType.Freeze, StatusType.Paralysis, StatusType.Poison, StatusType.PoisonBadly, StatusType.Sleep, StatusType.Infatuated);

    public CurryDishItem(EnumCurryKey key) {
        super(new Item.Properties());
    }

    public String getItemStackDisplayName(ItemStack stack) {
        EnumBerryFlavor flavor = EnumBerryFlavor.NONE;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BerryFlavor")) {
            flavor = EnumBerryFlavor.values()[stack.m_41783_().m_128445_("BerryFlavor")];
        }
        return I18n.m_118938_((String)this.m_5524_(), (Object[])new Object[]{I18n.m_118938_((String)("berry.flavor." + flavor.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0])}).trim();
    }

    public boolean useCurry(ItemStack stack, PokemonLink pokemon) {
        EnumCurryRating rating = EnumCurryRating.KOFFING;
        if (stack.m_41782_() && stack.m_41783_().m_128448_("CurryQuality") != 0) {
            rating = EnumCurryRating.values()[stack.m_41783_().m_128445_("CurryQuality")];
        }
        pokemon.sendMessage("item.pixelmon.curry.used", stack.m_41786_(), pokemon.getNickname());
        int currentHealth = pokemon.getHealth();
        int maxHealth = pokemon.getMaxHealth();
        if (currentHealth < maxHealth) {
            pokemon.setHealth((int)Math.min((double)maxHealth, (double)currentHealth + (double)maxHealth * rating.hpHeal));
            pokemon.update(EnumUpdateType.HP);
        }
        pokemon.adjustFriendship(rating.happinessBoost);
        pokemon.getPokemon().getPokemonLevelContainer().awardEXP(rating.expBoost, rating.getGainType());
        if (rating.ppRestore) {
            for (int i = 0; i < pokemon.getMoveset().size(); ++i) {
                pokemon.getMoveset().get((int)i).pp = pokemon.getMoveset().get(i).getMaxPP();
            }
        }
        if (rating.statusCure) {
            PixelmonItems.full_heal.useMedicine(pokemon, 0);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        CompoundTag nbt = stack.m_41783_();
        int flavor = 0;
        if (nbt != null && nbt.m_128441_("BerryFlavor")) {
            flavor = nbt.m_128448_("BerryFlavor");
        }
        ChatFormatting flavorColor = ChatFormatting.GRAY;
        switch (flavor) {
            case 0: {
                flavorColor = ChatFormatting.GOLD;
                break;
            }
            case 1: {
                flavorColor = ChatFormatting.BLUE;
                break;
            }
            case 2: {
                flavorColor = ChatFormatting.RED;
                break;
            }
            case 3: {
                flavorColor = ChatFormatting.GREEN;
                break;
            }
            case 4: {
                flavorColor = ChatFormatting.YELLOW;
                break;
            }
        }
        tooltip.add((Component)Component.m_237115_((String)EnumBerryFlavor.values()[flavor].getLocalizedName()).m_130940_(flavorColor));
        int rating = 0;
        if (nbt != null && nbt.m_128441_("CurryQuality")) {
            rating = nbt.m_128448_("CurryQuality");
        }
        ChatFormatting ratingColor = ChatFormatting.DARK_PURPLE;
        switch (rating) {
            case 1: {
                ratingColor = ChatFormatting.BLUE;
                break;
            }
            case 2: {
                ratingColor = ChatFormatting.DARK_RED;
                break;
            }
            case 3: {
                ratingColor = ChatFormatting.GRAY;
                break;
            }
            case 4: {
                ratingColor = ChatFormatting.GOLD;
            }
        }
        tooltip.add((Component)Component.m_237110_((String)"item.pixelmon.curry.tooltip", (Object[])new Object[]{EnumCurryRating.values()[rating].getLocalizedName()}).m_130940_(ratingColor));
        super.m_7373_(stack, world, tooltip, advanced);
    }
}

