/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.StatueEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.UpdateClientEditingStatuePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Event;

public class ChiselItem
extends PixelmonItem {
    public ChiselItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction side = context.m_43719_();
        if (side != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Vec3 hitVec = context.m_43720_();
        if (!world.f_46443_) {
            if (!ChiselItem.checkPermission((ServerPlayer)player)) {
                return InteractionResult.FAIL;
            }
            StatueEntity statue = new StatueEntity(world);
            Species pokemon = player.m_6144_() && player.m_7500_() ? PixelmonSpecies.getRandomSpecies() : PixelmonSpecies.BULBASAUR.getValueUnsafe();
            statue.setPokemon(PokemonFactory.create(pokemon));
            statue.m_6034_(hitVec.f_82479_, pos.m_123342_() + 1, hitVec.f_82481_);
            StatueEvent.CreateStatue createStatueEvent = new StatueEvent.CreateStatue((ServerPlayer)player, (ServerLevel)world, pos, statue);
            if (Pixelmon.EVENT_BUS.post((Event)createStatueEvent)) {
                return InteractionResult.FAIL;
            }
            statue = createStatueEvent.getStatue();
            statue.f_19857_ = statue.f_20885_ = player.f_19857_ + 180.0f;
            world.m_7967_((Entity)statue);
            NetworkHelper.sendPacket(new UpdateClientEditingStatuePacket(statue.m_20148_()), (ServerPlayer)player);
            OpenScreenPacket.open(player, EnumGuiScreen.StatueEditor, statue.m_19879_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof StatueEntity && !player.f_19853_.f_46443_ && !Pixelmon.EVENT_BUS.post((Event)new StatueEvent.DestroyStatue((ServerPlayer)player, (StatueEntity)entity))) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public static boolean checkPermission(ServerPlayer editingPlayer) {
        if (PixelmonConfigProxy.getGeneral().isAllowChisels() && PlayerHelper.hasPermission(editingPlayer, "pixelmon.chisel.use")) {
            return true;
        }
        ChatHandler.sendChat((Entity)editingPlayer, "gui.chisel.notallowedserver", new Object[0]);
        return false;
    }
}

