/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleForceEndCause;
import com.pixelmonmod.pixelmon.api.events.battles.ForceEndBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Mist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class BattleItem
extends PixelmonItem {
    public com.pixelmonmod.pixelmon.api.battles.BattleItem type;
    private boolean infinite;

    public BattleItem(com.pixelmonmod.pixelmon.api.battles.BattleItem type) {
        super(new Item.Properties().m_41487_(16).setNoRepair());
        this.type = type;
        this.infinite = type == com.pixelmonmod.pixelmon.api.battles.BattleItem.RED_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.GREEN_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.BLUE_FLUTE || type == com.pixelmonmod.pixelmon.api.battles.BattleItem.YELLOW_FLUTE;
    }

    public boolean execute(PixelmonWrapper pxm) {
        switch (this.type) {
            case RED_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Infatuated)) {
                    pxm.bc.sendToAll("pixelmon.status.infatuatedcureitem", pxm.getOwnerName(), pxm.getNickname());
                    pxm.removeStatus(StatusType.Infatuated, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case GREEN_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.getMaxHealth() > pxm.getHealth()) {
                    pxm.bc.sendToAll("pixelmon.effect.restorehealth", pxm.getNickname());
                    pxm.healEntityBy(20);
                    pxm.update(EnumUpdateType.HP);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case YELLOW_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Confusion)) {
                    pxm.bc.sendToAll("pixelmon.status.confusioncureitem", pxm.getOwnerName(), pxm.getNickname());
                    pxm.removeStatus(StatusType.Confusion, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case BLUE_FLUTE: {
                pxm.bc.sendToAll("pixelmon.abilities.flute", pxm.getOwnerName(), this.getLocalizedName());
                if (pxm.hasStatus(StatusType.Sleep)) {
                    pxm.bc.sendToAll("pixelmon.status.wokeup", pxm.getNickname());
                    pxm.removeStatus(StatusType.Sleep, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case DIRE_HIT: {
                if (pxm.getBattleStats().getCritStage() == 0) {
                    pxm.getBattleStats().increaseCritStage(2, false);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case MAX_MUSHROOM: {
                pxm.getBattleStats().modifyStat(1, BattleStatsType.ATTACK);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.DEFENSE);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_ATTACK);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_DEFENSE);
                pxm.getBattleStats().modifyStat(1, BattleStatsType.SPEED);
                return true;
            }
            case GUARD_SPEC: {
                if (pxm.addTeamStatus(new Mist(), pxm)) {
                    pxm.bc.sendToAll("pixelmon.effect.usemist", pxm.getNickname());
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
            case FLUFFY_TAIL: {
                ForceEndBattleEvent event = new ForceEndBattleEvent(pxm.bc, BattleForceEndCause.FLUFFY_TAIL);
                if (!Pixelmon.EVENT_BUS.post((Event)event)) {
                    pxm.bc.endBattle(BattleEndCause.FORCE);
                    return true;
                }
                pxm.bc.sendToAll("pixelmon.general.noeffect", new Object[0]);
                return false;
            }
        }
        pxm.getBattleStats().modifyStat(2, this.type.getEffectType());
        return true;
    }

    @Override
    public boolean useFromBag(PixelmonWrapper userWrapper, PixelmonWrapper targetWrapper, ItemStack stack) {
        return this.execute(userWrapper) && super.useFromBag(userWrapper, targetWrapper, stack) && !this.infinite;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43724_() == InteractionHand.MAIN_HAND && this.type == com.pixelmonmod.pixelmon.api.battles.BattleItem.MAX_MUSHROOM) {
            context.m_43719_();
            if (context.m_43719_() == Direction.UP) {
                BlockState lower;
                BlockPos up = context.m_8083_().m_7494_();
                if (context.m_43725_().m_46859_(up) && (lower = context.m_43725_().m_8055_(context.m_8083_())).m_60734_() instanceof MyceliumBlock) {
                    if (!context.m_43725_().f_46443_) {
                        if (!context.m_43723_().m_7500_()) {
                            context.m_43722_().m_41774_(1);
                        }
                        context.m_43725_().m_46597_(up, PixelmonBlocks.max_mushroom.m_49966_());
                        context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (context.m_43723_() != null) {
                        context.m_43723_().m_6674_(InteractionHand.MAIN_HAND);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }
}

