/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.OpenBadgeCasePacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BadgeCaseItem
extends PixelmonItem
implements IEquippable {
    private final EnumBadgeCase color;

    public BadgeCaseItem(EnumBadgeCase color) {
        super(new Item.Properties().m_41487_(1));
        this.color = color;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            BadgeCaseItem.openBadgeCase(stack, (ServerPlayer)player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public String getTooltipText() {
        return I18n.m_118938_((String)"item.pixelmon.badgecase.tooltip", (Object[])new Object[0]);
    }

    @Override
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @Override
    public String getEquippableModelKey() {
        return "badgecase";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public static void openBadgeCase(ItemStack stack, ServerPlayer player) {
        if (stack.m_41720_() instanceof BadgeCaseItem) {
            BadgeCase badgeCase = BadgeCase.readFromItemStack(stack);
            if (badgeCase == null) {
                NetworkHelper.sendPacket(new OpenBadgeCasePacket("", true, false, ((BadgeCaseItem)stack.m_41720_()).color, Collections.emptyList(), Collections.emptyList()), player);
            } else {
                NetworkHelper.sendPacket(new OpenBadgeCasePacket(badgeCase.owner, badgeCase.isOwner((Player)player), false, badgeCase.color, badgeCase.badges, Collections.emptyList()), player);
            }
        }
    }

    public static boolean registerBadgeCase(ItemStack stack, Player player) {
        if (stack.m_41720_() instanceof BadgeCaseItem) {
            BadgeCase badgeCase = BadgeCase.readFromItemStack(stack);
            if (badgeCase == null) {
                badgeCase = new BadgeCase(player.m_20148_(), player.m_7755_().getString(), ((BadgeCaseItem)stack.m_41720_()).color, Lists.newArrayList());
                badgeCase.writeToStack(stack);
                return true;
            }
            if (badgeCase.uuid == null) {
                badgeCase.uuid = player.m_20148_();
                badgeCase.owner = player.m_7755_().getString();
                badgeCase.color = ((BadgeCaseItem)stack.m_41720_()).color;
                badgeCase.writeToStack(stack);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static ItemStack removeBadge(ItemStack stack, Player player, int index) {
        BadgeCase badgeCase;
        if (stack.m_41720_() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && index >= 0 && index < badgeCase.badges.size()) {
            ItemStack removed = badgeCase.badges.remove(index);
            badgeCase.writeToStack(stack);
            return removed != null ? removed : ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static void swampBadge(ItemStack stack, Player player, int index1, int index2) {
        BadgeCase badgeCase;
        if (stack.m_41720_() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && index1 >= 0 && index2 >= 0 && index1 < badgeCase.badges.size() && index2 < badgeCase.badges.size()) {
            ItemStack stack1 = badgeCase.badges.get(index1);
            ItemStack stack2 = badgeCase.badges.get(index2);
            badgeCase.badges.set(index1, stack2);
            badgeCase.badges.set(index2, stack1);
            badgeCase.writeToStack(stack);
        }
    }

    public static boolean addBadge(ItemStack stack, Player player, ItemStack badge) {
        BadgeCase badgeCase;
        if (stack.m_41720_() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && badgeCase.badges.size() < 64) {
            badgeCase.badges.add(badge);
            badgeCase.writeToStack(stack);
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack findFirstRegisteredBadgeCase(Player player) {
        BadgeCase badgeCase;
        for (ItemStack stack : player.m_6167_()) {
            if (!(stack.m_41720_() instanceof BadgeCaseItem) || (badgeCase = BadgeCase.readFromItemStack(stack)) == null || !badgeCase.isOwner(player)) continue;
            return stack;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof BadgeCaseItem) || (badgeCase = BadgeCase.readFromItemStack(stack)) == null || !badgeCase.isOwner(player)) continue;
            return stack;
        }
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return (!stack.m_41782_() || !stack.m_41783_().m_128471_("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }

    public static class BadgeCase {
        private UUID uuid;
        private String owner;
        private EnumBadgeCase color;
        public List<ItemStack> badges;

        public BadgeCase(UUID uuid, String owner, EnumBadgeCase color, List<ItemStack> badges) {
            this.uuid = uuid;
            this.owner = owner;
            this.color = color;
            this.badges = badges;
        }

        public boolean isOwner(Player player) {
            return player.m_20148_().equals(this.uuid);
        }

        public void writeToStack(ItemStack stack) {
            CompoundTag compound = stack.m_41784_();
            if (this.uuid != null) {
                compound.m_128362_("OwnerUUID", this.uuid);
                compound.m_128359_("OwnerName", this.owner);
            } else {
                compound.m_128473_("OwnerUUID");
                compound.m_128473_("OwnerName");
            }
            if (!this.badges.isEmpty()) {
                ListTag list = new ListTag();
                for (ItemStack badge : this.badges) {
                    list.add((Object)badge.m_41739_(new CompoundTag()));
                }
                compound.m_128365_("Badges", (Tag)list);
            } else {
                compound.m_128473_("Badges");
            }
        }

        public static BadgeCase readFromItemStack(ItemStack stack) {
            if (!(stack.m_41720_() instanceof BadgeCaseItem)) {
                return null;
            }
            CompoundTag compound = stack.m_41783_();
            if (compound == null) {
                return null;
            }
            UUID uuid = null;
            String owner = "";
            EnumBadgeCase color = ((BadgeCaseItem)stack.m_41720_()).color;
            ArrayList badges = Lists.newArrayList();
            if (compound.m_128441_("OwnerUUID")) {
                uuid = compound.m_128342_("OwnerUUID");
                owner = compound.m_128461_("OwnerName");
            }
            if (compound.m_128441_("Badges")) {
                ListTag list = compound.m_128437_("Badges", 10);
                for (Tag tag : list) {
                    badges.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
                }
            }
            return new BadgeCase(uuid, owner, color, badges);
        }
    }
}

