/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class AbilityPatchItem
extends PixelmonItem {
    public AbilityPatchItem() {
        super(new Item.Properties());
    }

    public boolean useOnEntity(PixelmonEntity pixelmon, Player player) {
        if (pixelmon.getPokemon().hasHiddenAbility()) {
            pixelmon.getPokemon().setAbility(pixelmon.getForm().getAbilities().resolveAbility(0, false));
            pixelmon.getPokemon().overrideAbilitySlot();
            pixelmon.update(EnumUpdateType.Ability);
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.abilityitem", pixelmon.getNickname(), pixelmon.getPokemon().getAbility().getTranslatedName());
            return true;
        }
        if (pixelmon.getForm().getAbilities().getHiddenAbilities().length == 0 || pixelmon.getSpecies().is(PixelmonSpecies.ZYGARDE)) {
            ChatHandler.sendChat((Entity)player, "pixelmon.interaction.noeffect", new Object[0]);
            return false;
        }
        pixelmon.getPokemon().setAbility(pixelmon.getForm().getAbilities().getRandomHiddenAbility());
        pixelmon.getPokemon().overrideAbilitySlot();
        pixelmon.update(EnumUpdateType.Ability);
        ChatHandler.sendChat((Entity)player, "pixelmon.interaction.abilityitem", pixelmon.getNickname(), pixelmon.getPokemon().getAbility().getTranslatedName());
        return true;
    }
}

