/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.init.registry;

import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelPredicateType;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.AlwaysModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.BattleModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.FlyingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.RidingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.type.WalkingModelPredicate;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.MovementType;
import com.pixelmonmod.pixelmon.api.pokemon.species.parameters.mounted.MountedFlyingParameters;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PixelmonRegistry {
    private static final int MAX_VARINT = 0x7FFFFFFE;
    public static ResourceKey<Registry<MovementType<?>>> MOVEMENT_LOGIC_TYPES_REGISTRY = ResourceKey.m_135788_((ResourceLocation)ResourceLocationHelper.of("pixelmon", "movement_logic_type"));
    public static ResourceKey<Registry<ModelPredicateType<?>>> MODEL_PREDICATE_TYPES_REGISTRY = ResourceKey.m_135788_((ResourceLocation)ResourceLocationHelper.of("pixelmon", "model_predicate_type"));
    public static Supplier<IForgeRegistry<MovementType<?>>> movementLogicTypes;
    public static Supplier<IForgeRegistry<ModelPredicateType<?>>> modelPredicateTypes;

    @SubscribeEvent
    public static void onRegistry(NewRegistryEvent event) {
        movementLogicTypes = event.create(PixelmonRegistry.makeRegistry(MOVEMENT_LOGIC_TYPES_REGISTRY, PixelmonRegistry.classOf(MovementType.class)).disableSync().disableSaving().allowModification());
        modelPredicateTypes = event.create(PixelmonRegistry.makeRegistry(MODEL_PREDICATE_TYPES_REGISTRY, PixelmonRegistry.classOf(ModelPredicateType.class)).disableSaving().disableSaving().allowModification());
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        if (event.getRegistryKey().m_135782_() == MOVEMENT_LOGIC_TYPES_REGISTRY.m_135782_()) {
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "default"), new MovementType<MountedFlyingParameters>(MountedFlyingParameters.CODEC));
        }
        if (event.getRegistryKey().m_135782_() == MODEL_PREDICATE_TYPES_REGISTRY.m_135782_()) {
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "always"), new ModelPredicateType<AlwaysModelPredicate>(AlwaysModelPredicate.CODEC));
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "flying"), new ModelPredicateType<FlyingModelPredicate>(FlyingModelPredicate.CODEC));
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "riding"), new ModelPredicateType<RidingModelPredicate>(RidingModelPredicate.CODEC));
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "battle"), new ModelPredicateType<BattleModelPredicate>(BattleModelPredicate.CODEC));
            event.getForgeRegistry().register(ResourceLocationHelper.of("pixelmon", "walk"), new ModelPredicateType<WalkingModelPredicate>(WalkingModelPredicate.CODEC));
        }
    }

    private static <T> RegistryBuilder<T> makeRegistry(ResourceKey<? extends Registry<T>> key, Class<T> type) {
        return new RegistryBuilder().setName(key.m_135782_()).setMaxID(0x7FFFFFFE);
    }

    private static <T> Class<T> classOf(Class<?> clazz) {
        return clazz;
    }
}

