/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.init.registry;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.items.fireworks.PixelmonFireworkShape;
import com.pixelmonmod.pixelmon.items.fireworks.shapes.Charizard;
import com.pixelmonmod.pixelmon.items.fireworks.shapes.Pikachu;
import java.util.Map;
import net.minecraft.world.item.FireworkRocketItem;

public class FireworkRegistration {
    public static Map<String, FireworkRocketItem.Shape> SHAPES = Maps.newHashMap();
    public static Map<String, PixelmonFireworkShape> FIREWORK_PLUS_SHAPES = Maps.newHashMap();

    public static void init() {
        Pixelmon.LOGGER.debug("Starting firework initialization!");
        FireworkRegistration.register(new Pikachu());
        FireworkRegistration.register(new Charizard());
    }

    public static void register(PixelmonFireworkShape shape) {
        Pixelmon.LOGGER.debug("Registering Firework: " + shape.getName());
        FIREWORK_PLUS_SHAPES.put(shape.getName(), shape);
        SHAPES.put(shape.getName(), FireworkRocketItem.Shape.create((String)("pixelmon:" + shape.getName()), (int)shape.getID(), (String)("pixelmon." + shape.getName())));
    }
}

