/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.init.loaders;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.loader.DatapackLoader;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.daycare.DayCareConditionRegistry;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.impl.DeveloperRibbonType;
import com.pixelmonmod.pixelmon.api.pokemon.species.DataCopier;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.replacement.ReplacementLogicRegistry;
import com.pixelmonmod.pixelmon.api.replacement.SpawnReplacementRegistry;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.PossibleTradeList;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.DataSyncControlPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncAbilityPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncBossTiersPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncMovesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncNPCsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncPokeBallsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncPossibleTradesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncRibbonsPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncShopKeepersPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncSpawningPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncSpeciesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.sync.SyncStartersPacket;
import com.pixelmonmod.pixelmon.config.starter.StarterList;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.init.registry.RaidRegistry;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.tools.TriConsumer;
import com.pixelmonmod.pixelmon.world.dimension.debug.PixelmonDebugChunkGenerator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PixelmonLoaders {
    private static final Pattern SPECIES_PATTERN = Pattern.compile("[0-9]{3,}");
    public static final Map<String, TriConsumer<Gson, ResourceLocation, JsonElement>> CONFIG_PROCESSORS = Maps.newHashMap();
    public static final AtomicInteger SEARCH_TREE_SYNC_COUNTER;
    public static final int SEARCH_TREE_SYNC_COUNT = 2;
    public static final String ABILITY_DATA = "abilities";
    public static final String SPECIES_DATA = "species";
    public static final String MOVES_DATA = "moves";
    public static final String DROPS_DATA = "drops";
    public static final String BOSS_TIERS_DATA = "bosstiers";
    public static final String QUEST_DATA = "quests";
    public static final String RAID_DATA = "raids";
    public static final String RULES_DATA = "rules";
    public static final String SPAWNING_DATA = "spawning";
    public static final String CONFIG_DATA = "config";
    public static final String NPC_DATA = "npcs";
    public static final String POKEBALL_DATA = "pokeballs";
    public static final String SPAWN_REPLACEMENT = "spawn_replacement";
    public static final String DAY_CARE_DATA = "daycare";
    public static final String RIBBONS = "ribbons";

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        DatapackLoader.builder("pixelmon").gson(RibbonRegistry.GSON).type(RIBBONS).process(RibbonRegistry::register).task(() -> {
            RibbonRegistry.ISI.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("isi").translationKey("ribbon.isi").suffix((Component)Component.m_237115_((String)"ribbon.isi.title")).description((Component)Component.m_237115_((String)"ribbon.isi.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/isi.png"))).build());
            RibbonRegistry.OA10712.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("oa10712").translationKey("ribbon.oa10712").suffix((Component)Component.m_237115_((String)"ribbon.oa10712.title")).description((Component)Component.m_237115_((String)"ribbon.oa10712.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/oa10712.png"))).build());
            RibbonRegistry.WATERDUDE.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("waterdude").translationKey("ribbon.waterdude").suffix((Component)Component.m_237115_((String)"ribbon.waterdude.title")).description((Component)Component.m_237115_((String)"ribbon.waterdude.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/waterdude.png"))).build());
            RibbonRegistry.JAY113355.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("jay113355").translationKey("ribbon.jay113355").suffix((Component)Component.m_237115_((String)"ribbon.jay113355.title")).description((Component)Component.m_237115_((String)"ribbon.jay113355.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/jay113355.png"))).build());
            RibbonRegistry.RAS.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("ras").translationKey("ribbon.ras").suffix((Component)Component.m_237115_((String)"ribbon.ras.title")).description((Component)Component.m_237115_((String)"ribbon.ras.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/ras.png"))).build());
            RibbonRegistry.RIBCHOP.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("ribchop").translationKey("ribbon.ribchop").suffix((Component)Component.m_237115_((String)"ribbon.ribchop.title")).description((Component)Component.m_237115_((String)"ribbon.ribchop.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/ribchop.png"))).build());
            RibbonRegistry.ASA.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("asa").translationKey("ribbon.asa").suffix((Component)Component.m_237115_((String)"ribbon.asa.title")).description((Component)Component.m_237115_((String)"ribbon.asa.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/asa.png"))).build());
            RibbonRegistry.WOP.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("wop").translationKey("ribbon.wop").suffix((Component)Component.m_237115_((String)"ribbon.wop.title")).description((Component)Component.m_237115_((String)"ribbon.wop.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/wop.png"))).build());
            RibbonRegistry.DANIEL_N.invalidate();
            RibbonRegistry.register(DeveloperRibbonType.builder().id("daniel_n").translationKey("ribbon.daniel_n").suffix((Component)Component.m_237115_((String)"ribbon.daniel_n.title")).description((Component)Component.m_237115_((String)"ribbon.daniel_n.description")).icon(ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon:textures/gui/ribbons/daniel_n.png"))).build());
        }).create(event);
        DatapackLoader.builder("pixelmon").gson(PokeBallRegistry.GSON).type(POKEBALL_DATA).process(PokeBallRegistry::register).create(event);
        DatapackLoader.builder("pixelmon").gson(new GsonBuilder().create()).type(ABILITY_DATA).process((gson, resourceLocation, jsonElement) -> {
            JsonObject asJsonObject = jsonElement.getAsJsonObject();
            AbilityRegistry.register(asJsonObject.get("className").getAsString());
        }).create(event);
        DatapackLoader.builder("pixelmon").gson(AttackRegistry.GSON).type(MOVES_DATA).task(AttackRegistry::removeAllAttacks).process((gson, rl, json) -> AttackRegistry.addAttack((ImmutableAttack)gson.fromJson(json, ImmutableAttack.class), rl, json.toString())).create(event);
        DatapackLoader.builder("pixelmon").gson(Species.GSON).type(SPECIES_DATA).task(() -> RegistryManager.invalidateRegistry(Species.class)).process((gson, rl, json) -> {
            try {
                if (SPECIES_PATTERN.matcher(rl.m_135815_()).find()) {
                    PixelmonSpecies.addSpecies((Species)gson.fromJson(json, Species.class));
                }
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Error reading JSON file at path " + rl.toString(), (Throwable)e);
            }
        }).task(PixelmonSpecies::init).task(Pokedex::resetPokedex).task(Pokedex::loadPokedex).task(DataCopier::resetAll).task(ExtraStats::init).task(FormLogRegistry::init).task(PixelmonDebugChunkGenerator::init).task(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.m_6846_() != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
                    for (Pokemon pokemon : pps.getAll()) {
                        if (pokemon == null) continue;
                        pokemon.markDirty(EnumUpdateType.ALL);
                    }
                    PCStorage pcs = StorageProxy.getPCForPlayerNow(player);
                    for (Pokemon pokemon : pcs.getAll()) {
                        if (pokemon == null) continue;
                        pokemon.markDirty(EnumUpdateType.ALL);
                    }
                }
            }
        }).create(event);
        DatapackLoader.builder("pixelmon").gson(BossTierRegistry.GSON).type(BOSS_TIERS_DATA).task(BossTierRegistry::reset).process((gson, rl, json) -> BossTierRegistry.readFromJson(gson, json)).task(BossTierRegistry::addNotBossIfNotPresent).create(event);
        DatapackLoader.builder("pixelmon").gson(DayCareConditionRegistry.GSON).type(DAY_CARE_DATA).task(DayCareConditionRegistry::reset).process((gson, rl, json) -> DayCareConditionRegistry.readFromJson(gson, json)).create(event);
        DatapackLoader.builder("pixelmon").gson(new Gson()).type(DROPS_DATA).task(DropItemRegistry::clearDrops).process((gson, rl, json) -> DropItemRegistry.registerDropItems(rl, json)).create(event);
        DatapackLoader.builder("pixelmon").gson(QuestRegistry.GSON).type(QUEST_DATA).task(() -> {
            QuestRegistry.getInstance().registerClasses();
            QuestRegistry.getInstance().getQuests().clear();
        }).process((gson, rl, json) -> {
            Quest quest = (Quest)gson.fromJson(json, Quest.class);
            String path = rl.m_135815_();
            String[] segments = path.split("/");
            quest.setFilename(segments[segments.length - 1]);
            QuestRegistry.getInstance().addQuest(quest);
        }).create(event);
        DatapackLoader.builder("pixelmon").gson(new Gson()).type(RAID_DATA).task(() -> RaidRegistry.getBiomeToRaids().clear()).process((gson, rl, json) -> RaidRegistry.registerRaidSpawns(json.getAsJsonObject())).task(RaidRegistry::remap).create(event);
        DatapackLoader.builder("pixelmon").gson(SpawnSet.GSON).type(CONFIG_DATA).task(ServerNPCRegistry::clear).process(PixelmonLoaders::processConfigFile).create(event);
        DatapackLoader.builder("pixelmon").gson(SpawnSet.GSON).type(SPAWNING_DATA).task(PixelmonSpawning::clearSpawning).process((gson, rl, json) -> {
            if (!rl.toString().contains("betterspawnerconfig")) {
                SpawnSet set = (SpawnSet)gson.fromJson(json, SpawnSet.CLASS);
                if (set == null) {
                    return;
                }
                try {
                    if (set.spawnInfos != null && !set.spawnInfos.isEmpty()) {
                        set.spawnInfos.removeIf(spawnInfo -> {
                            if (!(spawnInfo instanceof SpawnInfoPokemon)) {
                                return false;
                            }
                            SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
                            RegistryValue species = spawnInfoPokemon.getPokemonSpec().getValue(SpeciesRequirement.class).orElse(null);
                            if (species == null || species.getValueUnsafe() == null) {
                                Pixelmon.LOGGER.warn("Bad spec: " + spawnInfoPokemon.getPokemonSpec().toString() + " in " + spawnInfo.set.id + ".set.json");
                            } else if (!PixelmonConfigProxy.getSpawning().isGenerationEnabled(((Species)species.getValueUnsafe()).getGeneration())) {
                                return true;
                            }
                            return species == null || species.getValueUnsafe() == null;
                        });
                    }
                    PixelmonSpawning.loadSpawnSet(set, rl);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).task(PixelmonSpawning::initialize).create(event);
        DatapackLoader.builder("pixelmon").gson(ServerNPCRegistry.GSON).type(NPC_DATA).process(ServerNPCRegistry::register).task(CommonProxy::loadDefaultMoveSkills).task(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PixelmonLoaders::reloadMoveSkills)).create(event);
        DatapackLoader.builder("pixelmon").gson(ReplacementLogicRegistry.GSON).type(SPAWN_REPLACEMENT).task(SpawnReplacementRegistry::reset).process(SpawnReplacementRegistry::register).create(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void reloadMoveSkills() {
        ClientProxy.moveSkills.clear();
        ClientProxy.moveSkills.addAll(MoveSkill.moveSkills);
    }

    private static void processConfigFile(Gson gson, ResourceLocation rl, JsonElement json) {
        String[] split = rl.m_135815_().split("/");
        String id = split[split.length - 1].replace(".json", "").toLowerCase(Locale.ROOT);
        TriConsumer<Gson, ResourceLocation, JsonElement> processor = CONFIG_PROCESSORS.get(id);
        if (processor != null) {
            processor.accept(gson, rl, json);
        }
    }

    @SubscribeEvent
    public static void syncData(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            NetworkHelper.sendPacket(player, new DataSyncControlPacket("pixelmon", true, 60000L));
            NetworkHelper.sendPacket(player, new SyncRibbonsPacket());
            SyncPokeBallsPacket.sync(event.getPlayer());
            SyncAbilityPacket.sync(event.getPlayer());
            SyncMovesPacket.sync(event.getPlayer());
            SyncSpeciesPacket.sync(event.getPlayer());
            SyncBossTiersPacket.sync(event.getPlayer());
            SyncStartersPacket.sync(event.getPlayer());
            SyncShopKeepersPacket.sync(event.getPlayer());
            SyncNPCsPacket.sync(event.getPlayer());
            SyncPossibleTradesPacket.sync(event.getPlayer());
            SyncSpawningPacket.sync(event.getPlayer());
            NetworkHelper.sendPacket(player, new DataSyncControlPacket("pixelmon", false, -1L));
        }
    }

    public static void tryReloadSearchTrees(boolean last) {
        if (SEARCH_TREE_SYNC_COUNTER.get() == 0) {
            SEARCH_TREE_SYNC_COUNTER.set(3);
        }
        if (last && SEARCH_TREE_SYNC_COUNTER.decrementAndGet() <= 1) {
            SEARCH_TREE_SYNC_COUNTER.set(0);
        }
    }

    static {
        CONFIG_PROCESSORS.put("betterspawnerconfig", (gson, rl, json) -> BetterSpawnerConfig.load(gson, json));
        CONFIG_PROCESSORS.put("shopitems", (gson, rl, json) -> ServerNPCRegistry.shopkeepers.registerShopItems((JsonElement)json));
        CONFIG_PROCESSORS.put("trainers", (gson, rl, json) -> ServerNPCRegistry.readTrainerTypes(json));
        CONFIG_PROCESSORS.put("trades", (gson, rl, json) -> PossibleTradeList.registerTrades(gson, json));
        CONFIG_PROCESSORS.put("starters", (gson, rl, json) -> StarterList.readFromJson(gson, json));
        SEARCH_TREE_SYNC_COUNTER = new AtomicInteger(0);
    }
}

