/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;

public enum EnumStatueTextureType implements ITranslatable
{
    OriginalTexture(0),
    Stone(3, ResourceLocationHelper.of("pixelmon:textures/pokemon/statue.png")),
    Gold(4, ResourceLocationHelper.of("pixelmon:textures/pokemon/gold.png")),
    Bronze(5, ResourceLocationHelper.of("pixelmon:textures/pokemon/bronze.png")),
    Silver(6, ResourceLocationHelper.of("pixelmon:textures/pokemon/silver.png")),
    Green(7, new Color(0, 212, 63)),
    Yellow(8, Color.YELLOW),
    Red(9, Color.RED),
    Orange(10, new Color(255, 162, 0)),
    Cyan(11, Color.CYAN),
    Blue(12, new Color(0, 110, 255)),
    Indigo(13, new Color(64, 0, 255)),
    Magenta(14, new Color(199, 0, 217)),
    Pink(15, Color.PINK),
    Gray(16, Color.GRAY),
    Brown(17, new Color(145, 82, 0));

    public int index;
    public Color color;
    public ResourceLocation texture;

    private EnumStatueTextureType(int index) {
        this(index, Color.WHITE);
    }

    private EnumStatueTextureType(int index, Color color) {
        this.index = index;
        this.color = color;
    }

    private EnumStatueTextureType(int index, ResourceLocation texture) {
        this.index = index;
        this.texture = texture;
    }

    public static EnumStatueTextureType getFromOrdinal(int value) {
        if (value >= EnumStatueTextureType.values().length) {
            return Red;
        }
        for (EnumStatueTextureType t : EnumStatueTextureType.values()) {
            if (t.ordinal() != value) continue;
            return t;
        }
        return null;
    }

    public EnumStatueTextureType getNextType(EnumStatueTextureType t) {
        int index = t.ordinal();
        index = index >= EnumStatueTextureType.values().length - 1 ? 0 : ++index;
        return EnumStatueTextureType.getFromOrdinal(index);
    }

    public static EnumStatueTextureType getFromString(String name) {
        for (EnumStatueTextureType t : EnumStatueTextureType.values()) {
            if (!t.toString().equalsIgnoreCase(name)) continue;
            return t;
        }
        return OriginalTexture;
    }

    @Override
    public String getTranslationKey() {
        return "enum.statuetex." + this.toString().toLowerCase(Locale.ROOT);
    }
}

