/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import net.minecraftforge.common.ForgeI18n;

public enum EnumCurryRating {
    KOFFING(0.25, false, false, 200, 10, ExperienceGainType.CURRY_KOFFING),
    WOBBUFFET(0.5, false, false, 480, 25, ExperienceGainType.CURRY_WOBBUFFET),
    MILCERY(1.0, false, true, 1050, 40, ExperienceGainType.CURRY_MILCERY),
    COPPERAJAH(1.0, true, true, 1890, 50, ExperienceGainType.CURRY_COPPERAJAH),
    CHARIZARD(1.0, true, true, 2980, 75, ExperienceGainType.CURRY_CHARIZARD);

    public final double hpHeal;
    public final boolean ppRestore;
    public final boolean statusCure;
    public final int expBoost;
    public final int happinessBoost;
    private final ExperienceGainType gainType;

    private EnumCurryRating(double hpHeal, boolean ppRestore, boolean statusCure, int expBoost, int happinessBoost, ExperienceGainType gainType) {
        this.hpHeal = hpHeal;
        this.ppRestore = ppRestore;
        this.statusCure = statusCure;
        this.expBoost = expBoost;
        this.happinessBoost = happinessBoost;
        this.gainType = gainType;
    }

    public static EnumCurryRating ratingFromQuality(int quality) {
        if (quality < 15) {
            return KOFFING;
        }
        if (quality < 40) {
            return WOBBUFFET;
        }
        if (quality < 75) {
            return MILCERY;
        }
        if (quality < 125) {
            return COPPERAJAH;
        }
        return CHARIZARD;
    }

    public static EnumCurryRating ratingFromOrdinal(int ordinal) {
        switch (ordinal) {
            default: {
                return KOFFING;
            }
            case 1: {
                return WOBBUFFET;
            }
            case 2: {
                return MILCERY;
            }
            case 3: {
                return COPPERAJAH;
            }
            case 4: 
        }
        return CHARIZARD;
    }

    public String getLocalizedName() {
        switch (this) {
            default: {
                return ForgeI18n.parseMessage((String)"pixelmon.generic.form.normal", (Object[])new Object[0]);
            }
            case KOFFING: {
                return ForgeI18n.parseMessage((String)"pixelmon.koffing", (Object[])new Object[0]);
            }
            case WOBBUFFET: {
                return ForgeI18n.parseMessage((String)"pixelmon.wobbuffet", (Object[])new Object[0]);
            }
            case MILCERY: {
                return ForgeI18n.parseMessage((String)"pixelmon.milcery", (Object[])new Object[0]);
            }
            case COPPERAJAH: {
                return ForgeI18n.parseMessage((String)"pixelmon.copperajah", (Object[])new Object[0]);
            }
            case CHARIZARD: 
        }
        return ForgeI18n.parseMessage((String)"pixelmon.charizard", (Object[])new Object[0]);
    }

    public ExperienceGainType getGainType() {
        return this.gainType;
    }
}

