/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public enum EnumCurryKey {
    PLAIN("plain"),
    TOAST("toast"),
    PASTA("pasta"),
    FRIED_FOOD("fried"),
    INSTANT_NOODLE("instant_noodle"),
    BURGER("burger"),
    SAUSAGE("sausage"),
    BEANS("beans"),
    MUSHROOM("mushroom"),
    POTATO("potato"),
    SALAD("salad"),
    SEASONED("seasoned"),
    JUICY("juicy"),
    RICH("rich"),
    BONE("bone"),
    HERB("herb"),
    CREAM("cream"),
    DECORATIVE("decorative"),
    COCONUT("coconut"),
    SMOKE_POKE("smoke_poke"),
    LEEK("leek"),
    APPLE("apple"),
    BOILED_EGG("egg"),
    TROPICAL("tropical"),
    CHEESE("cheesy"),
    GIGANTAMIX("gigantamix");

    private final ResourceLocation dishTexture;

    private EnumCurryKey(String tex) {
        this.dishTexture = ResourceLocationHelper.of(Resources.prefix + "item/curry/dish/" + tex + ".png");
    }

    public int getRatingBoost() {
        if (this.ordinal() == 0) {
            return 0;
        }
        if (this.ordinal() < 6) {
            return 2;
        }
        if (this.ordinal() < 12) {
            return 5;
        }
        if (this.ordinal() < 19) {
            return 8;
        }
        if (this.ordinal() < 25) {
            return 12;
        }
        return 20;
    }

    public Item getDishItem() {
        switch (this) {
            case TOAST: {
                return PixelmonItems.dish_curry_toast;
            }
            case PASTA: {
                return PixelmonItems.dish_curry_pasta;
            }
            case FRIED_FOOD: {
                return PixelmonItems.dish_curry_fried_food;
            }
            case INSTANT_NOODLE: {
                return PixelmonItems.dish_curry_instant_noodle;
            }
            case BURGER: {
                return PixelmonItems.dish_curry_burger;
            }
            case SAUSAGE: {
                return PixelmonItems.dish_curry_sausage;
            }
            case BEANS: {
                return PixelmonItems.dish_curry_beans;
            }
            case MUSHROOM: {
                return PixelmonItems.dish_curry_mushroom;
            }
            case POTATO: {
                return PixelmonItems.dish_curry_potato;
            }
            case SALAD: {
                return PixelmonItems.dish_curry_salad;
            }
            case SEASONED: {
                return PixelmonItems.dish_curry_seasoned;
            }
            case RICH: {
                return PixelmonItems.dish_curry_rich;
            }
            case JUICY: {
                return PixelmonItems.dish_curry_juicy;
            }
            case BONE: {
                return PixelmonItems.dish_curry_bone;
            }
            case HERB: {
                return PixelmonItems.dish_curry_herb;
            }
            case CREAM: {
                return PixelmonItems.dish_curry_cream;
            }
            case DECORATIVE: {
                return PixelmonItems.dish_curry_decorative;
            }
            case COCONUT: {
                return PixelmonItems.dish_curry_coconut;
            }
            case SMOKE_POKE: {
                return PixelmonItems.dish_curry_smoke_poke;
            }
            case LEEK: {
                return PixelmonItems.dish_curry_leek;
            }
            case APPLE: {
                return PixelmonItems.dish_curry_apple;
            }
            case BOILED_EGG: {
                return PixelmonItems.dish_curry_boiled_egg;
            }
            case TROPICAL: {
                return PixelmonItems.dish_curry_tropical;
            }
            case CHEESE: {
                return PixelmonItems.dish_curry_cheese;
            }
            case GIGANTAMIX: {
                return PixelmonItems.dish_curry_gigantamix;
            }
        }
        return PixelmonItems.dish_curry_plain;
    }

    public ResourceLocation getDishTexture() {
        return this.dishTexture;
    }

    @Nullable
    public Item getCurryIngredientItem() {
        if (this == PLAIN) {
            return null;
        }
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)("pixelmon:curry_" + this.toString().toLowerCase())));
    }

    public Item getCurryDishItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)("pixelmon:dish_curry_" + this.toString().toLowerCase())));
    }
}

